/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote;

import com.android.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.License;
import com.android.sdklib.repository.PreciseRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.w3c.dom.Node;

public abstract class RemotePkgInfo
implements Comparable<RemotePkgInfo> {
    protected IPkgDesc mPkgDesc;
    protected final String mObsolete;
    protected final License mLicense;
    protected final String mListDisplay;
    protected final String mDescription;
    protected final String mDescUrl;
    protected PreciseRevision mRevision;
    protected final Archive[] mArchives;
    protected final SdkSource mSource;
    private static final boolean sUsingUnixPerm = SdkConstants.CURRENT_PLATFORM == 3 || SdkConstants.CURRENT_PLATFORM == 1;

    public RemotePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        this.mSource = source;
        this.mListDisplay = RemotePackageParserUtils.getXmlString(packageNode, "list-display");
        this.mDescription = RemotePackageParserUtils.getXmlString(packageNode, "description");
        this.mDescUrl = RemotePackageParserUtils.getXmlString(packageNode, "desc-url");
        this.mObsolete = RemotePackageParserUtils.getOptionalXmlString(packageNode, "obsolete");
        this.mLicense = this.parseLicense(packageNode, licenses);
        this.mArchives = this.parseArchives(RemotePackageParserUtils.findChildElement(packageNode, "archives"));
        this.mRevision = RemotePackageParserUtils.parsePreciseRevisionElement(RemotePackageParserUtils.findChildElement(packageNode, "revision"));
    }

    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    public long getDownloadSize() {
        long size = 0L;
        for (Archive archive : this.mArchives) {
            if (!archive.isCompatible()) continue;
            size += archive.getSize();
        }
        return size;
    }

    @Override
    public int compareTo(RemotePkgInfo o) {
        return this.mPkgDesc.compareTo((Object)o.mPkgDesc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPkgDesc == null ? 0 : this.mPkgDesc.hashCode());
        return result;
    }

    public void saveProperties(Properties props) {
        if (this.mLicense != null) {
            String licenseRef;
            String license = this.mLicense.getLicense();
            if (license != null && license.length() > 0) {
                props.setProperty("Pkg.License", license);
            }
            if ((licenseRef = this.mLicense.getLicenseRef()) != null && licenseRef.length() > 0) {
                props.setProperty("Pkg.LicenseRef", licenseRef);
            }
        }
        if (this.mListDisplay != null && this.mListDisplay.length() > 0) {
            props.setProperty("Pkg.ListDisplay", this.mListDisplay);
        }
        if (this.mDescription != null && this.mDescription.length() > 0) {
            props.setProperty("Pkg.Desc", this.mDescription);
        }
        if (this.mDescUrl != null && this.mDescUrl.length() > 0) {
            props.setProperty("Pkg.DescUrl", this.mDescUrl);
        }
        if (this.mObsolete != null) {
            props.setProperty("Pkg.Obsolete", this.mObsolete);
        }
        if (this.mSource != null) {
            props.setProperty("Pkg.SourceUrl", this.mSource.getUrl());
        }
        props.setProperty("Pkg.Revision", this.mRevision.toString());
    }

    private License parseLicense(Node packageNode, Map<String, String> licenses) {
        Node ref;
        Node usesLicense = RemotePackageParserUtils.findChildElement(packageNode, "uses-license");
        if (usesLicense != null && (ref = usesLicense.getAttributes().getNamedItem("ref")) != null) {
            String licenseRef = ref.getNodeValue();
            return new License(licenses.get(licenseRef), licenseRef);
        }
        return null;
    }

    private Archive[] parseArchives(Node archivesNode) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        if (archivesNode != null) {
            String nsUri = archivesNode.getNamespaceURI();
            for (Node child = archivesNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"archive".equals(child.getLocalName())) continue;
                archives.add(this.parseArchive(child));
            }
        }
        return archives.toArray(new Archive[archives.size()]);
    }

    private Archive parseArchive(Node archiveNode) {
        Archive a = new Archive(this, RemotePackageParserUtils.parseArchFilter(archiveNode), RemotePackageParserUtils.getXmlString(archiveNode, "url"), RemotePackageParserUtils.getXmlLong(archiveNode, "size", 0L), RemotePackageParserUtils.getXmlString(archiveNode, "checksum"));
        return a;
    }

    public SdkSource getParentSource() {
        return this.mSource;
    }

    public boolean isObsolete() {
        return this.mObsolete != null;
    }

    public FullRevision getRevision() {
        return this.mRevision;
    }

    public License getLicense() {
        return this.mLicense;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getListDisplay() {
        return this.mListDisplay;
    }

    public String getDescUrl() {
        return this.mDescUrl;
    }

    public Archive[] getArchives() {
        return this.mArchives;
    }

    public boolean hasCompatibleArchive() {
        for (Archive archive : this.mArchives) {
            if (!archive.isCompatible()) continue;
            return true;
        }
        return false;
    }

    public abstract String installId();

    public String toString() {
        String s = this.getShortDescription();
        if (s != null) {
            return s;
        }
        return super.toString();
    }

    public final String getShortDescription() {
        return this.getPkgDesc().getDescriptionShort();
    }

    public abstract File getInstallFolder(String var1, SdkManager var2);

    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        return true;
    }

    public void postUnzipFileHook(Archive archive, ITaskMonitor monitor, IFileOp fileOp, File unzippedFile, ZipArchiveEntry zipEntry) {
        int mode;
        if (sUsingUnixPerm && fileOp.isFile(unzippedFile) && ((mode = zipEntry.getUnixMode()) & 0x49) != 0) {
            try {
                fileOp.setExecutablePermission(unzippedFile);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemotePkgInfo)) {
            return false;
        }
        RemotePkgInfo other = (RemotePkgInfo)obj;
        if (!Arrays.equals(this.mArchives, other.mArchives)) {
            return false;
        }
        if (this.mSource == null ? other.mSource != null : !this.mSource.equals(other.mSource)) {
            return false;
        }
        return this.getPkgDesc().equals(other.getPkgDesc());
    }

    public UpdateInfo canUpdate(LocalPkgInfo localPkg) {
        if (localPkg == null) {
            return UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(localPkg, FullRevision.PreviewComparison.IGNORE)) {
            return UpdateInfo.INCOMPATIBLE;
        }
        if (this.getRevision().isPreview() && !localPkg.getDesc().getFullRevision().isPreview()) {
            return UpdateInfo.INCOMPATIBLE;
        }
        if (localPkg.getDesc().getFullRevision().compareTo(this.getRevision()) < 0) {
            return UpdateInfo.UPDATE;
        }
        return UpdateInfo.NOT_UPDATE;
    }

    protected boolean sameItemAs(LocalPkgInfo pkg, FullRevision.PreviewComparison comparePreview) {
        IPkgDesc desc = this.getPkgDesc();
        IPkgDesc other = pkg.getDesc();
        return Objects.equal((Object)desc.getPath(), (Object)other.getPath()) && Objects.equal((Object)desc.getTag(), (Object)other.getTag()) && Objects.equal((Object)desc.getAndroidVersion(), (Object)other.getAndroidVersion()) && Objects.equal((Object)desc.getVendor(), (Object)other.getVendor()) && (comparePreview == FullRevision.PreviewComparison.IGNORE || desc.getFullRevision().isPreview() == other.getFullRevision().isPreview());
    }

    public static enum UpdateInfo {
        INCOMPATIBLE,
        NOT_UPDATE,
        UPDATE;

    }
}

