/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.archives;

import com.android.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.DownloadCache;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.archives.ArchiveReplacement;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import com.android.utils.GrabProcessOutput;
import com.android.utils.Pair;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class ArchiveInstaller {
    private static final String PROP_STATUS_CODE = "StatusCode";
    public static final String ENV_VAR_IGNORE_COMPAT = "ANDROID_SDK_IGNORE_COMPAT";
    public static final int NUM_MONITOR_INC = 100;
    private final IFileOp mFileOp = new FileOp();

    public boolean install(ArchiveReplacement archiveInfo, String osSdkRoot, boolean forceHttp, SdkManager sdkManager, DownloadCache cache, ITaskMonitor monitor) {
        File propsFile;
        boolean checkIsCompatible;
        Archive newArchive = archiveInfo.getNewArchive();
        RemotePkgInfo pkg = newArchive.getParentPackage();
        String name = pkg.getShortDescription();
        boolean bl = checkIsCompatible = System.getenv(ENV_VAR_IGNORE_COMPAT) == null;
        if (checkIsCompatible && !newArchive.isCompatible()) {
            monitor.log("Skipping incompatible archive: %1$s for %2$s", name, newArchive.getOsDescription());
            return false;
        }
        Pair<File, File> files = this.downloadFile(newArchive, osSdkRoot, cache, monitor, forceHttp);
        File tmpFile = files == null ? null : (File)files.getFirst();
        File file = propsFile = files == null ? null : (File)files.getSecond();
        if (tmpFile != null && this.unarchive(archiveInfo, osSdkRoot, tmpFile, sdkManager, monitor)) {
            monitor.log("Installed %1$s", name);
            this.mFileOp.deleteFileOrFolder(tmpFile);
            this.mFileOp.deleteFileOrFolder(propsFile);
            return true;
        }
        return false;
    }

    protected Pair<File, File> downloadFile(Archive archive, String osSdkRoot, DownloadCache cache, ITaskMonitor monitor, boolean forceHttp) {
        Header[] resumeHeaders;
        String pkgName = archive.getParentPackage().getShortDescription();
        monitor.setDescription("Downloading %1$s", pkgName);
        monitor.log("Downloading %1$s", pkgName);
        String link = archive.getUrl();
        if (!(link.startsWith("http://") || link.startsWith("https://") || link.startsWith("ftp://"))) {
            RemotePkgInfo pkg = archive.getParentPackage();
            SdkSource src = pkg.getParentSource();
            if (src == null) {
                monitor.logError("Internal error: no source for archive %1$s", pkgName);
                return null;
            }
            String repoXml = src.getUrl();
            int pos = repoXml.lastIndexOf(47);
            String base = repoXml.substring(0, pos + 1);
            link = base + link;
        }
        if (forceHttp) {
            link = link.replaceAll("https://", "http://");
        }
        int pos = link.lastIndexOf(47);
        String base = link.substring(pos + 1);
        File tmpFolder = this.getTempFolder(osSdkRoot);
        if (!this.mFileOp.isDirectory(tmpFolder)) {
            if (this.mFileOp.isFile(tmpFolder)) {
                this.mFileOp.deleteFileOrFolder(tmpFolder);
            }
            if (!this.mFileOp.mkdirs(tmpFolder)) {
                monitor.logError("Failed to create directory %1$s", tmpFolder.getPath());
                return null;
            }
        }
        File tmpFile = new File(tmpFolder, base);
        File propsFile = new File(tmpFolder, base + ".inf");
        if (this.mFileOp.exists(tmpFile) && this.mFileOp.length(tmpFile) == archive.getSize()) {
            String chksum = "";
            try {
                chksum = this.fileChecksum(archive.getChecksumType().getMessageDigest(), tmpFile, monitor);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
            if (chksum.equalsIgnoreCase(archive.getChecksum())) {
                return Pair.of((Object)tmpFile, (Object)propsFile);
            }
            this.mFileOp.deleteFileOrFolder(tmpFile);
        }
        if (this.fetchUrl(archive, resumeHeaders = this.preparePartialDownload(archive, tmpFile, propsFile), tmpFile, propsFile, link, pkgName, cache, monitor)) {
            return Pair.of((Object)tmpFile, (Object)propsFile);
        }
        return null;
    }

    private Header[] preparePartialDownload(Archive archive, File tmpFile, File propsFile) {
        if (this.mFileOp.isFile(tmpFile) && this.mFileOp.isFile(propsFile) && this.mFileOp.length(tmpFile) < archive.getSize()) {
            Properties props = this.mFileOp.loadProperties(propsFile);
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>(2);
            headers.add(new BasicHeader("Range", String.format("bytes=%d-", this.mFileOp.length(tmpFile))));
            int status = 0;
            try {
                status = Integer.parseInt(props.getProperty(PROP_STATUS_CODE));
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (status == 200 || status == 206) {
                String etag = props.getProperty("ETag");
                String lastMod = props.getProperty("Last-Modified");
                if (etag != null && etag.length() > 0) {
                    headers.add(new BasicHeader("If-Match", etag));
                } else if (lastMod != null && lastMod.length() > 0) {
                    headers.add(new BasicHeader("If-Match", lastMod));
                }
                return headers.toArray(new Header[headers.size()]);
            }
        }
        this.mFileOp.deleteFileOrFolder(tmpFile);
        this.mFileOp.deleteFileOrFolder(propsFile);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileChecksum(MessageDigest digester, File tmpFile, ITaskMonitor monitor) {
        FileInputStream is = null;
        try {
            int n;
            is = new FileInputStream(tmpFile);
            byte[] buf = new byte[65536];
            while ((n = ((InputStream)is).read(buf)) >= 0) {
                if (n <= 0) continue;
                digester.update(buf, 0, n);
            }
            String string = this.getDigestChecksum(digester);
            return string;
        }
        catch (FileNotFoundException e) {
            monitor.logError("File not found: %1$s", e.getMessage());
        }
        catch (Exception e) {
            monitor.logError("%1$s", e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return "";
    }

    private String getDigestChecksum(MessageDigest digester) {
        byte[] digest = digester.digest();
        int n = digest.length;
        String hex = "0123456789abcdef";
        char[] hexDigest = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int b = digest[i] & 0xFF;
            hexDigest[i * 2 + 0] = hex.charAt(b >>> 4);
            hexDigest[i * 2 + 1] = hex.charAt(b & 0xF);
        }
        return new String(hexDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchUrl(Archive archive, Header[] resumeHeaders, File tmpFile, File propsFile, String urlString, String pkgName, DownloadCache cache, ITaskMonitor monitor) {
        FileOutputStream os = null;
        InputStream is = null;
        int inc_remain = 100;
        try {
            String expected;
            int n;
            long inc;
            boolean append;
            String lastModified;
            Pair<InputStream, HttpURLConnection> result = cache.openDirectUrl(urlString, resumeHeaders, monitor);
            is = (InputStream)result.getFirst();
            HttpURLConnection connection = (HttpURLConnection)result.getSecond();
            int status = connection.getResponseCode();
            if (status == 404) {
                throw new Exception("URL not found.");
            }
            if (is == null) {
                throw new Exception("No content.");
            }
            Properties props = new Properties();
            props.setProperty(PROP_STATUS_CODE, Integer.toString(status));
            String etag = connection.getHeaderField("ETag");
            if (etag != null) {
                props.setProperty("ETag", etag);
            }
            if ((lastModified = connection.getHeaderField("Last-Modified")) != null) {
                props.setProperty("Last-Modified", lastModified);
            }
            try {
                this.mFileOp.saveProperties(propsFile, props, "## Android SDK Download.");
            }
            catch (IOException ignore) {
                // empty catch block
            }
            boolean bl = append = status == 206;
            if (!(status == 200 || append && resumeHeaders != null)) {
                throw new Exception(String.format("Unexpected HTTP Status %1$d", status));
            }
            MessageDigest digester = archive.getChecksumType().getMessageDigest();
            if (append) {
                FileInputStream temp = null;
                try {
                    int n2;
                    temp = new FileInputStream(tmpFile);
                    byte[] buf = new byte[65536];
                    while ((n2 = ((InputStream)temp).read(buf)) >= 0) {
                        if (n2 <= 0) continue;
                        digester.update(buf, 0, n2);
                    }
                }
                catch (Exception ignore) {
                }
                finally {
                    if (temp != null) {
                        try {
                            ((InputStream)temp).close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            os = new FileOutputStream(tmpFile, append);
            byte[] buf = new byte[65536];
            long total = 0L;
            long size = archive.getSize();
            if (append) {
                long len = this.mFileOp.length(tmpFile);
                int percent = (int)(len * 100L / size);
                size -= len;
                monitor.logVerbose("Resuming %1$s download at %2$d (%3$d%%)", pkgName, len, percent);
            }
            long next_inc = inc = size / 100L;
            long startMs = System.currentTimeMillis();
            long nextMs = startMs + 2000L;
            while ((n = is.read(buf)) >= 0) {
                if (n > 0) {
                    os.write(buf, 0, n);
                    digester.update(buf, 0, n);
                }
                long timeMs = System.currentTimeMillis();
                if ((total += (long)n) >= next_inc) {
                    monitor.incProgress(1);
                    --inc_remain;
                    next_inc += inc;
                }
                if (timeMs > nextMs) {
                    long delta = timeMs - startMs;
                    if (total > 0L && delta > 0L) {
                        int percent = (int)(100L * total / size);
                        float speed = (float)total / (float)delta * 0.9765625f;
                        int timeLeft = (double)speed > 0.001 ? (int)((float)(size - total) / 1024.0f / speed) : 0;
                        String timeUnit = "seconds";
                        if (timeLeft > 120) {
                            timeUnit = "minutes";
                            timeLeft /= 60;
                        }
                        monitor.setDescription("Downloading %1$s (%2$d%%, %3$.0f KiB/s, %4$d %5$s left)", pkgName, percent, Float.valueOf(speed), timeLeft, timeUnit);
                    }
                    nextMs = timeMs + 1000L;
                }
                if (!monitor.isCancelRequested()) continue;
                monitor.log("Download aborted by user at %1$d bytes.", total);
                boolean bl2 = false;
                return bl2;
            }
            if (total != size) {
                monitor.logError("Download finished with wrong size. Expected %1$d bytes, got %2$d bytes.", size, total);
                boolean timeMs = false;
                return timeMs;
            }
            String actual = this.getDigestChecksum(digester);
            if (!actual.equalsIgnoreCase(expected = archive.getChecksum())) {
                monitor.logError("Download finished with wrong checksum. Expected %1$s, got %2$s.", expected, actual);
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            monitor.logError("URL not found: %1$s", e.getMessage());
        }
        catch (Exception e) {
            monitor.logError("Download interrupted: %1$s", e.getMessage());
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (inc_remain > 0) {
                monitor.incProgress(inc_remain);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unarchive(ArchiveReplacement archiveInfo, String osSdkRoot, File archiveFile, SdkManager sdkManager, ITaskMonitor monitor) {
        boolean bl;
        File oldDestFolder;
        block36: {
            RemotePkgInfo pkg;
            Archive newArchive;
            block37: {
                File oldFolder;
                File destFolder;
                boolean success;
                block33: {
                    boolean tryAgain;
                    block34: {
                        block35: {
                            block30: {
                                block31: {
                                    block32: {
                                        block27: {
                                            block28: {
                                                block29: {
                                                    block21: {
                                                        boolean bl2;
                                                        block22: {
                                                            boolean bl3;
                                                            block23: {
                                                                block24: {
                                                                    String pkgKind;
                                                                    block18: {
                                                                        boolean bl4;
                                                                        block19: {
                                                                            block20: {
                                                                                String pkgName;
                                                                                block15: {
                                                                                    boolean bl5;
                                                                                    block16: {
                                                                                        block17: {
                                                                                            success = false;
                                                                                            newArchive = archiveInfo.getNewArchive();
                                                                                            pkg = newArchive.getParentPackage();
                                                                                            pkgName = pkg.getShortDescription();
                                                                                            monitor.setDescription("Installing %1$s", pkgName);
                                                                                            monitor.log("Installing %1$s", pkgName);
                                                                                            pkgKind = pkg.getClass().getSimpleName();
                                                                                            destFolder = null;
                                                                                            oldDestFolder = null;
                                                                                            destFolder = pkg.getInstallFolder(osSdkRoot, sdkManager);
                                                                                            if (destFolder != null) break block15;
                                                                                            monitor.log("Failed to compute installation directory for %1$s.", pkgName);
                                                                                            bl5 = false;
                                                                                            if (success) break block16;
                                                                                            if (oldDestFolder == null) break block17;
                                                                                            this.restoreFolder(oldDestFolder, destFolder);
                                                                                        }
                                                                                        pkg.postInstallHook(newArchive, monitor, null);
                                                                                    }
                                                                                    this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                                                                    return bl5;
                                                                                }
                                                                                if (pkg.preInstallHook(newArchive, monitor, osSdkRoot, destFolder)) break block18;
                                                                                monitor.log("Skipping archive: %1$s", pkgName);
                                                                                bl4 = false;
                                                                                if (success) break block19;
                                                                                if (oldDestFolder == null) break block20;
                                                                                this.restoreFolder(oldDestFolder, destFolder);
                                                                            }
                                                                            pkg.postInstallHook(newArchive, monitor, null);
                                                                        }
                                                                        this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                                                        return bl4;
                                                                    }
                                                                    if (!this.mFileOp.exists(destFolder)) break block21;
                                                                    if (oldDestFolder == null) {
                                                                        oldDestFolder = this.getNewTempFolder(osSdkRoot, pkgKind, "old");
                                                                    }
                                                                    if (oldDestFolder != null) break block22;
                                                                    monitor.logError("Failed to find a temp directory in %1$s.", osSdkRoot);
                                                                    bl3 = false;
                                                                    if (success) break block23;
                                                                    if (oldDestFolder == null) break block24;
                                                                    this.restoreFolder(oldDestFolder, destFolder);
                                                                }
                                                                pkg.postInstallHook(newArchive, monitor, null);
                                                            }
                                                            this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                                            return bl3;
                                                        }
                                                        try {
                                                            while (!this.moveFolder(destFolder, oldDestFolder)) {
                                                                monitor.logError("Failed to rename directory %1$s to %2$s.", destFolder.getPath(), oldDestFolder.getPath());
                                                                if (SdkConstants.CURRENT_PLATFORM != 2) break;
                                                                tryAgain = true;
                                                                tryAgain = this.windowsDestDirLocked(osSdkRoot, destFolder, monitor);
                                                                if (tryAgain) continue;
                                                                bl2 = false;
                                                                if (success) break block25;
                                                                if (oldDestFolder == null) break block26;
                                                                this.restoreFolder(oldDestFolder, destFolder);
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            if (!success) {
                                                                if (oldDestFolder != null) {
                                                                    this.restoreFolder(oldDestFolder, destFolder);
                                                                }
                                                                pkg.postInstallHook(newArchive, monitor, null);
                                                            }
                                                            this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                                            throw throwable;
                                                        }
                                                        {
                                                            block25: {
                                                                block26: {
                                                                }
                                                                pkg.postInstallHook(newArchive, monitor, null);
                                                            }
                                                            this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                                            return bl2;
                                                        }
                                                    }
                                                    assert (!this.mFileOp.exists(destFolder));
                                                    if (this.mFileOp.mkdirs(destFolder)) break block27;
                                                    monitor.logError("Failed to create directory %1$s", destFolder.getPath());
                                                    tryAgain = false;
                                                    if (success) break block28;
                                                    if (oldDestFolder == null) break block29;
                                                    this.restoreFolder(oldDestFolder, destFolder);
                                                }
                                                pkg.postInstallHook(newArchive, monitor, null);
                                            }
                                            this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                            return tryAgain;
                                        }
                                        if (this.unzipFolder(archiveInfo, archiveFile, destFolder, monitor)) break block30;
                                        tryAgain = false;
                                        if (success) break block31;
                                        if (oldDestFolder == null) break block32;
                                        this.restoreFolder(oldDestFolder, destFolder);
                                    }
                                    pkg.postInstallHook(newArchive, monitor, null);
                                }
                                this.mFileOp.deleteFileOrFolder(oldDestFolder);
                                return tryAgain;
                            }
                            if (this.generateSourceProperties(newArchive, destFolder)) break block33;
                            monitor.logError("Failed to generate source.properties in directory %1$s", destFolder.getPath());
                            tryAgain = false;
                            if (success) break block34;
                            if (oldDestFolder == null) break block35;
                            this.restoreFolder(oldDestFolder, destFolder);
                        }
                        pkg.postInstallHook(newArchive, monitor, null);
                    }
                    this.mFileOp.deleteFileOrFolder(oldDestFolder);
                    return tryAgain;
                }
                LocalPkgInfo oldArchive = archiveInfo.getReplaced();
                if (oldArchive != null && this.mFileOp.exists(oldFolder = oldArchive.getLocalDir()) && !oldFolder.equals(destFolder)) {
                    monitor.logVerbose("Removing old archive at %1$s", oldFolder.getAbsolutePath());
                    this.mFileOp.deleteFileOrFolder(oldFolder);
                }
                success = true;
                pkg.postInstallHook(newArchive, monitor, destFolder);
                bl = true;
                if (success) break block36;
                if (oldDestFolder == null) break block37;
                this.restoreFolder(oldDestFolder, destFolder);
            }
            pkg.postInstallHook(newArchive, monitor, null);
        }
        this.mFileOp.deleteFileOrFolder(oldDestFolder);
        return bl;
    }

    private boolean windowsDestDirLocked(String osSdkRoot, File destFolder, final ITaskMonitor monitor) {
        String msg = null;
        assert (SdkConstants.CURRENT_PLATFORM == 2);
        File findLockExe = FileOp.append((String)osSdkRoot, (String[])new String[]{"tools", "lib", SdkConstants.FN_FIND_LOCK});
        if (this.mFileOp.exists(findLockExe)) {
            try {
                final StringBuilder result = new StringBuilder();
                String[] command = new String[]{findLockExe.getAbsolutePath(), destFolder.getAbsolutePath()};
                Process process = Runtime.getRuntime().exec(command);
                int retCode = GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                    public void out(String line) {
                        if (line != null) {
                            result.append(line).append("\n");
                        }
                    }

                    public void err(String line) {
                        if (line != null) {
                            monitor.logError("[find_lock] Error: %1$s", line);
                        }
                    }
                });
                if (retCode == 0 && result.length() > 0) {
                    String found = result.toString().trim();
                    monitor.logError("[find_lock] Directory locked by %1$s", found);
                    TreeSet<String> apps = new TreeSet<String>(Arrays.asList(found.split(Pattern.quote(";"))));
                    StringBuilder appStr = new StringBuilder();
                    for (String app : apps) {
                        appStr.append("\n  - ").append(app.trim());
                    }
                    msg = String.format("-= Warning ! =-\nThe following processes: %1$s\nare locking the following directory: \n  %2$s\nPlease close these applications so that the installation can continue.\nWhen ready, press YES to try again.", appStr.toString(), destFolder.getPath());
                }
            }
            catch (Exception e) {
                monitor.error(e, "[find_lock failed]", new Object[0]);
            }
        }
        if (msg == null) {
            msg = String.format("-= Warning ! =-\nA folder failed to be moved. On Windows this typically means that a program is using that folder (for example Windows Explorer or your anti-virus software.)\nPlease momentarily deactivate your anti-virus software or close any running programs that may be accessing the directory '%1$s'.\nWhen ready, press YES to try again.", destFolder.getPath());
        }
        boolean tryAgain = monitor.displayPrompt("SDK Manager: failed to install", msg);
        return tryAgain;
    }

    private boolean moveFolder(File oldDir, File newDir) {
        for (int i = 0; i < 5; ++i) {
            if (this.mFileOp.renameTo(oldDir, newDir)) {
                return true;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean unzipFolder(ArchiveReplacement archiveInfo, File archiveFile, File unzipDestFolder, ITaskMonitor monitor) {
        Archive newArchive = archiveInfo.getNewArchive();
        RemotePkgInfo pkg = newArchive.getParentPackage();
        String pkgName = pkg.getShortDescription();
        long compressedSize = newArchive.getSize();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            long incStep = compressedSize / 100L;
            long incTotal = 0L;
            long incCurr = 0L;
            int lastPercent = 0;
            byte[] buf = new byte[65536];
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                long remains;
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String name = entry.getName();
                int pos = (name = name.replace('\\', '/')).indexOf(47);
                if (pos != -1) {
                    if (pos == name.length() - 1) continue;
                    name = name.substring(pos + 1);
                }
                File destFile = new File(unzipDestFolder, name);
                if (name.endsWith("/")) {
                    if (this.mFileOp.isDirectory(destFile) || this.mFileOp.mkdirs(destFile)) continue;
                    monitor.logError("Failed to create directory %1$s", destFile.getPath());
                    boolean bl = false;
                    return bl;
                }
                if (name.indexOf(47) != -1) {
                    File parentDir;
                    if (this.mFileOp.exists(destFile)) {
                        monitor.logVerbose("Duplicate file found:  %1$s", name);
                    }
                    if (!this.mFileOp.isDirectory(parentDir = destFile.getParentFile()) && !this.mFileOp.mkdirs(parentDir)) {
                        monitor.logError("Failed to create directory %1$s", parentDir.getPath());
                        boolean e = false;
                        return e;
                    }
                }
                FileOutputStream fos = null;
                try {
                    int n;
                    fos = new FileOutputStream(destFile);
                    InputStream entryContent = zipFile.getInputStream(entry);
                    for (remains = entry.getSize(); remains > 0L && (n = entryContent.read(buf, 0, (int)Math.min(remains, (long)buf.length))) != -1; remains -= (long)n) {
                        if (n <= 0) continue;
                        fos.write(buf, 0, n);
                    }
                }
                catch (EOFException e) {
                    monitor.logError("Error uncompressing file %s. Size: %d bytes, Unwritten: %d bytes.", entry.getName(), entry.getSize(), remains);
                    throw e;
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
                pkg.postUnzipFileHook(newArchive, monitor, this.mFileOp, destFile, entry);
                incTotal += entry.getCompressedSize();
                while (incCurr < incTotal) {
                    monitor.incProgress(1);
                    incCurr += incStep;
                }
                int percent = (int)(100L * incTotal / compressedSize);
                if (percent != lastPercent) {
                    monitor.setDescription("Unzipping %1$s (%2$d%%)", pkgName, percent);
                    lastPercent = percent;
                }
                if (!monitor.isCancelRequested()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            monitor.logError("Unzip failed: %1$s", e.getMessage());
            return false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File getNewTempFolder(String osBasePath, String prefix, String suffix) {
        File baseTempFolder = this.getTempFolder(osBasePath);
        if (!this.mFileOp.isDirectory(baseTempFolder)) {
            if (this.mFileOp.isFile(baseTempFolder)) {
                this.mFileOp.deleteFileOrFolder(baseTempFolder);
            }
            if (!this.mFileOp.mkdirs(baseTempFolder)) {
                return null;
            }
        }
        for (int i = 1; i < 100; ++i) {
            File folder = new File(baseTempFolder, String.format("%1$s.%2$s%3$02d", prefix, suffix, i));
            if (this.mFileOp.exists(folder)) continue;
            return folder;
        }
        return null;
    }

    private File getTempFolder(String osBasePath) {
        File baseTempFolder = new File(osBasePath, "temp");
        return baseTempFolder;
    }

    protected boolean generateSourceProperties(Archive archive, File unzipDestFolder) {
        Properties props = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                TreeSet<Object> sortedSet = new TreeSet<Object>(this.keySet());
                final Iterator it = sortedSet.iterator();
                return new Enumeration<Object>(){

                    @Override
                    public boolean hasMoreElements() {
                        return it.hasNext();
                    }

                    @Override
                    public Object nextElement() {
                        return it.next();
                    }
                };
            }
        };
        archive.saveProperties(props);
        RemotePkgInfo pkg = archive.getParentPackage();
        if (pkg != null) {
            pkg.saveProperties(props);
        }
        try {
            this.mFileOp.saveProperties(new File(unzipDestFolder, "source.properties"), props, "## Android Tool: Source of this archive.");
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    private boolean restoreFolder(File srcFolder, File destFolder) {
        boolean result = true;
        File[] srcFiles = this.mFileOp.listFiles(srcFolder);
        if (srcFiles == null) {
            return false;
        }
        if (this.mFileOp.isFile(destFolder)) {
            if (!this.mFileOp.delete(destFolder)) {
                return false;
            }
        } else if (!this.mFileOp.isDirectory(destFolder)) {
            this.mFileOp.mkdirs(destFolder);
        }
        HashSet<File> destDirs = new HashSet<File>();
        HashSet<File> destFiles = new HashSet<File>();
        File[] files = this.mFileOp.listFiles(destFolder);
        if (files != null) {
            for (File f : files) {
                if (this.mFileOp.isDirectory(f)) {
                    destDirs.add(f);
                    continue;
                }
                destFiles.add(f);
            }
        }
        for (File dir : srcFiles) {
            if (!this.mFileOp.isDirectory(dir)) continue;
            File d = new File(destFolder, dir.getName());
            destDirs.remove(d);
            if (this.restoreFolder(dir, d)) continue;
            result = false;
        }
        for (File dir : destDirs) {
            this.mFileOp.deleteFileOrFolder(dir);
        }
        for (File file : srcFiles) {
            if (!this.mFileOp.isFile(file)) continue;
            File f = new File(destFolder, file.getName());
            destFiles.remove(f);
            try {
                this.mFileOp.copyFile(file, f);
            }
            catch (IOException e) {
                result = false;
            }
        }
        for (File file : destFiles) {
            this.mFileOp.deleteFileOrFolder(file);
        }
        return result;
    }
}

