/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalBuildToolPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.io.File;
import java.util.Map;
import org.w3c.dom.Node;

public class RemoteBuildToolPkgInfo
extends RemotePkgInfo {
    private static final String INSTALL_ID_BASE = "build-tools-";

    public RemoteBuildToolPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newBuildTool((FullRevision)this.getRevision());
        pkgDescBuilder.setDescriptionShort(RemoteBuildToolPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteBuildToolPkgInfo.createListDescription(this.mListDisplay, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public String installId() {
        return this.getPkgDesc().getInstallId();
    }

    private static String createListDescription(String listDisplay, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Build-tools%1$s", obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, FullRevision revision, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Build-tools, revision %1$s%2$s", revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "build-tools");
        StringBuilder sb = new StringBuilder();
        PreciseRevision revision = this.getPkgDesc().getPreciseRevision();
        int[] version = revision.toIntArray(false);
        for (int i = 0; i < version.length; ++i) {
            sb.append(version[i]);
            if (i == version.length - 1) continue;
            sb.append('.');
        }
        if (this.getPkgDesc().getPreciseRevision().isPreview()) {
            sb.append("-preview");
        }
        folder = new File(folder, sb.toString());
        return folder;
    }

    @Override
    public boolean sameItemAs(LocalPkgInfo pkg, FullRevision.PreviewComparison comparePreview) {
        if (pkg instanceof LocalBuildToolPkgInfo) {
            LocalBuildToolPkgInfo rhs = (LocalBuildToolPkgInfo)pkg;
            return rhs.getDesc().getFullRevision().compareTo(this.getRevision(), comparePreview) == 0;
        }
        return false;
    }
}

