/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.updater;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.ISdkChangeListener;
import com.android.sdklib.repository.License;
import com.android.sdklib.util.LineUtil;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.AdbWrapper;
import com.android.tools.idea.sdk.remote.internal.DownloadCache;
import com.android.tools.idea.sdk.remote.internal.ITask;
import com.android.tools.idea.sdk.remote.internal.ITaskFactory;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.archives.ArchiveInstaller;
import com.android.tools.idea.sdk.remote.internal.packages.PlatformToolRemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteAddonPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteToolPkgInfo;
import com.android.tools.idea.sdk.remote.internal.sources.SdkRepoSource;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSourceCategory;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSources;
import com.android.tools.idea.sdk.remote.internal.updater.ArchiveInfo;
import com.android.tools.idea.sdk.remote.internal.updater.SettingsController;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkData;

public class UpdaterData {
    public static final int NO_TOOLS_MSG = 0;
    public static final int TOOLS_MSG_UPDATED_FROM_ADT = 1;
    public static final int TOOLS_MSG_UPDATED_FROM_SDKMAN = 2;
    private String mOsSdkRoot;
    private final SdkSources mSources = new SdkSources();
    private final ArrayList<ISdkChangeListener> mListeners = new ArrayList();
    private final ILogger mSdkLog;
    private ITaskFactory mTaskFactory;
    private SdkManager mSdkManager;
    private DownloadCache mDownloadCache;

    public UpdaterData(String osSdkRoot, ILogger sdkLog) {
        this.mOsSdkRoot = osSdkRoot;
        this.mSdkLog = sdkLog;
        this.initSdk();
    }

    public String getOsSdkRoot() {
        return this.mOsSdkRoot;
    }

    public DownloadCache getDownloadCache() {
        if (this.mDownloadCache == null) {
            this.mDownloadCache = new DownloadCache(SettingsController.getInstance().getUseDownloadCache() ? DownloadCache.Strategy.FRESH_CACHE : DownloadCache.Strategy.DIRECT);
        }
        return this.mDownloadCache;
    }

    public void setTaskFactory(ITaskFactory taskFactory) {
        this.mTaskFactory = taskFactory;
    }

    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    public void removeListener(ISdkChangeListener listener) {
        this.mListeners.remove(listener);
    }

    protected void runOnUiThread(Runnable r) {
        r.run();
    }

    protected void initSdk() {
        this.setSdkManager(SdkManager.createManager((String)this.mOsSdkRoot, (ILogger)this.mSdkLog));
        this.broadcastOnSdkReload();
    }

    protected void setSdkManager(SdkManager sdkManager) {
        this.mSdkManager = sdkManager;
    }

    public void reloadSdk() {
        this.mSdkManager.reloadSdk(this.mSdkLog);
        this.broadcastOnSdkReload();
    }

    public void setupDefaultSources() {
        String baseUrl = System.getenv("SDK_TEST_BASE_URL");
        if (baseUrl == null || baseUrl.length() <= 0 || !baseUrl.endsWith("/")) {
            baseUrl = "https://dl.google.com/android/repository/";
        }
        this.mSources.add(SdkSourceCategory.ANDROID_REPO, new SdkRepoSource(baseUrl, SdkSourceCategory.ANDROID_REPO.getUiName()));
        this.mSources.loadUserAddons(this.mSdkLog);
    }

    protected List<Archive> installArchives(final List<ArchiveInfo> archives, final int flags) {
        if (this.mTaskFactory == null) {
            throw new IllegalArgumentException("Task Factory is null");
        }
        final ArrayList<Archive> newlyInstalledArchives = new ArrayList<Archive>();
        final boolean forceHttp = SettingsController.getInstance().getForceHttp();
        Collections.sort(archives, new InstallOrderComparator());
        this.mTaskFactory.start("Installing Archives", new ITask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ITaskMonitor monitor) {
                int progressPerArchive = 200;
                monitor.setProgressMax(1 + archives.size() * 200);
                monitor.setDescription("Preparing to install archives", new Object[0]);
                boolean installedAddon = false;
                boolean installedTools = false;
                boolean installedPlatformTools = false;
                boolean preInstallHookInvoked = false;
                int numInstalled = 0;
                block10: for (ArchiveInfo ai : archives) {
                    Archive archive = ai.getNewArchive();
                    if (archive == null) continue;
                    int nextProgress = monitor.getProgress() + 200;
                    try {
                        ArchiveInstaller installer;
                        if (monitor.isCancelRequested()) break;
                        ArchiveInfo[] adeps = ai.getDependsOn();
                        if (adeps != null) {
                            for (ArchiveInfo adep : adeps) {
                                Archive na = adep.getNewArchive();
                                if (na != null) continue;
                                monitor.log("Skipping '%1$s'; it depends on a missing package.", archive.getParentPackage().getShortDescription());
                                continue block10;
                            }
                        }
                        if (!preInstallHookInvoked) {
                            preInstallHookInvoked = true;
                            UpdaterData.this.broadcastPreInstallHook();
                        }
                        if (!(installer = UpdaterData.this.createArchiveInstaler()).install(ai, UpdaterData.this.mOsSdkRoot, forceHttp, UpdaterData.this.mSdkManager, UpdaterData.this.getDownloadCache(), monitor)) continue;
                        newlyInstalledArchives.add(archive);
                        ++numInstalled;
                        if (archive.getParentPackage() instanceof RemoteAddonPkgInfo) {
                            installedAddon = true;
                            continue;
                        }
                        if (archive.getParentPackage() instanceof RemoteToolPkgInfo) {
                            installedTools = true;
                            continue;
                        }
                        if (!(archive.getParentPackage() instanceof PlatformToolRemotePkgInfo)) continue;
                        installedPlatformTools = true;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        if (msg != null) {
                            msg = String.format("Unexpected Error installing '%1$s': %2$s: %3$s", archive.getParentPackage().getShortDescription(), t.getClass().getCanonicalName(), msg);
                        } else {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(baos));
                            msg = String.format("Unexpected Error installing '%1$s'\n%2$s", archive.getParentPackage().getShortDescription(), baos.toString());
                        }
                        monitor.log("%1$s", msg);
                        UpdaterData.this.mSdkLog.error(t, "%1$s", new Object[]{msg});
                    }
                    finally {
                        monitor.incProgress(nextProgress - monitor.getProgress());
                    }
                }
                if (installedAddon) {
                    try {
                        UpdaterData.this.mSdkManager.updateAdb();
                        monitor.log("Updated ADB to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                    catch (Exception e) {
                        UpdaterData.this.mSdkLog.error((Throwable)e, "Update ADB failed", new Object[0]);
                        monitor.logError("failed to update adb to support the USB devices declared in the SDK add-ons.", new Object[0]);
                    }
                }
                if (preInstallHookInvoked) {
                    UpdaterData.this.broadcastPostInstallHook();
                }
                if (installedAddon || installedPlatformTools) {
                    UpdaterData.this.askForAdbRestart(monitor);
                }
                if (installedTools) {
                    UpdaterData.this.notifyToolsNeedsToBeRestarted(flags);
                }
                if (numInstalled == 0) {
                    monitor.setDescription("Done. Nothing was installed.", new Object[0]);
                } else {
                    monitor.setDescription("Done. %1$d %2$s installed.", numInstalled, numInstalled == 1 ? "package" : "packages");
                    UpdaterData.this.reloadSdk();
                }
            }
        });
        return newlyInstalledArchives;
    }

    protected void askForAdbRestart(ITaskMonitor monitor) {
        if (!SettingsController.getInstance().getAskBeforeAdbRestart()) {
            AdbWrapper adb = new AdbWrapper(this.getOsSdkRoot(), monitor);
            adb.stopAdb();
            adb.startAdb();
        }
    }

    protected void notifyToolsNeedsToBeRestarted(int flags) {
        String msg = null;
        if ((flags & 1) == 1) {
            msg = "The Android SDK and AVD Manager that you are currently using has been updated. Please also run Eclipse > Help > Check for Updates to see if the Android plug-in needs to be updated.";
        } else if ((flags & 2) == 2) {
            msg = "The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you use Eclipse, please run Help > Check for Updates to see if the Android plug-in needs to be updated.";
        } else if ((flags & 0) == 0) {
            return;
        }
        this.mSdkLog.info("%s", new Object[]{msg});
    }

    public List<Archive> updateOrInstallAll_NoGUI(Collection<String> pkgFilter, boolean includeAll, boolean dryMode, String acceptLicense, boolean includeDependencies) {
        ArrayList archives = this.getRemoteArchives(includeAll);
        if (pkgFilter != null && pkgFilter.size() > 0 && archives != null && archives.size() > 0) {
            HashSet<String> installIds = new HashSet<String>();
            for (ArchiveInfo ai : archives) {
                String iid;
                RemotePkgInfo p;
                Archive a = ai.getNewArchive();
                if (a == null || (p = a.getParentPackage()) == null || (iid = p.installId().toLowerCase(Locale.US)).length() <= 0 || installIds.contains(iid)) continue;
                installIds.add(iid);
            }
            HashSet<String> userFilteredInstallIds = new HashSet<String>();
            for (String iid : pkgFilter) {
                if (installIds.contains(iid = iid.toLowerCase(Locale.US))) {
                    userFilteredInstallIds.add(iid);
                    continue;
                }
                this.mSdkLog.error(null, "Ignoring unknown package filter '%1$s'", new Object[]{iid});
            }
            Iterator it = archives.iterator();
            while (it.hasNext()) {
                RemotePkgInfo p;
                boolean keep = false;
                ArchiveInfo ai = (ArchiveInfo)it.next();
                Archive a = ai.getNewArchive();
                if (a != null && (p = a.getParentPackage()) != null && userFilteredInstallIds.contains(p.installId().toLowerCase(Locale.US))) {
                    keep = true;
                }
                if (keep) continue;
                it.remove();
            }
            if (archives.isEmpty()) {
                this.mSdkLog.info(LineUtil.reflowLine((String)"Warning: The package filter removed all packages. There is nothing to install.\nPlease consider trying to update again without a package filter.\n"), new Object[0]);
                return null;
            }
        }
        if (archives != null && !archives.isEmpty()) {
            List<ArchiveInfo> dependencies;
            if (includeDependencies && !(dependencies = UpdaterData.getDependencies(archives)).isEmpty()) {
                ArrayList combined = Lists.newArrayList();
                combined.addAll(dependencies);
                combined.addAll(archives);
                archives = combined;
            }
            if (dryMode) {
                this.mSdkLog.info("Packages selected for install:\n", new Object[0]);
                for (ArchiveInfo ai : archives) {
                    RemotePkgInfo p;
                    Archive a = ai.getNewArchive();
                    if (a == null || (p = a.getParentPackage()) == null) continue;
                    this.mSdkLog.info("- %1$s\n", new Object[]{p.getShortDescription()});
                }
                this.mSdkLog.info("\nDry mode is on so nothing is actually being installed.\n", new Object[0]);
            } else if (this.acceptLicense(archives, acceptLicense, 100)) {
                return this.installArchives(archives, 0);
            }
        } else {
            this.mSdkLog.info("There is nothing to install or update.\n", new Object[0]);
        }
        return null;
    }

    private List<ArchiveInfo> getRemoteArchives(boolean includeAll) {
        SdkState state = SdkState.getInstance(AndroidSdkData.getSdkData(this.mOsSdkRoot));
        state.loadSynchronously(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, null, null, false);
        ArrayList result = Lists.newArrayList();
        for (UpdatablePkgInfo update : state.getPackages().getConsolidatedPkgs().values()) {
            for (RemotePkgInfo remote : update.getAllRemotes()) {
                if (!includeAll && remote.isObsolete()) continue;
                for (Archive archive : remote.getArchives()) {
                    if (!archive.isCompatible()) continue;
                    result.add(new ArchiveInfo(archive, update.getLocalInfo(), null));
                }
            }
        }
        return result;
    }

    private static List<ArchiveInfo> getDependencies(List<ArchiveInfo> archives) {
        ArrayList dependencies = Lists.newArrayList();
        for (ArchiveInfo archive : archives) {
            UpdaterData.addDependencies(dependencies, archive, Sets.newHashSet());
        }
        return dependencies;
    }

    private static void addDependencies(List<ArchiveInfo> dependencies, ArchiveInfo archive, Set<ArchiveInfo> visited) {
        if (visited.contains(archive)) {
            return;
        }
        visited.add(archive);
        ArchiveInfo[] dependsOn = archive.getDependsOn();
        if (dependsOn != null) {
            for (ArchiveInfo dependency : dependsOn) {
                if (dependencies.contains(dependency)) continue;
                dependencies.add(dependency);
                UpdaterData.addDependencies(dependencies, dependency, visited);
            }
        }
    }

    /*
     * Exception decompiling
     */
    boolean acceptLicense(List<ArchiveInfo> archives, String acceptLicenseIds, int numRetries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private License getArchiveInfoLicense(ArchiveInfo ai) {
        License lic;
        RemotePkgInfo p;
        Archive a = ai.getNewArchive();
        if (a != null && (p = a.getParentPackage()) != null && (lic = p.getLicense()) != null && lic.getLicenseRef() != null && lic.getLicense().length() > 0 && lic.getLicense() != null && lic.getLicense().length() > 0) {
            return lic;
        }
        return null;
    }

    private String getLicenseId(License lic) {
        return String.format("%1$s-%2$08x", lic.getLicenseRef(), lic.getLicense().hashCode());
    }

    private void broadcastOnSdkReload() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.onSdkReload();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastPreInstallHook() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.preInstallHook();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private void broadcastPostInstallHook() {
        if (this.mListeners.size() > 0) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (ISdkChangeListener listener : UpdaterData.this.mListeners) {
                        try {
                            listener.postInstallHook();
                        }
                        catch (Throwable t) {
                            UpdaterData.this.mSdkLog.error(t, null, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    protected ArchiveInstaller createArchiveInstaler() {
        return new ArchiveInstaller();
    }

    private static class InstallOrderComparator
    implements Comparator<ArchiveInfo> {
        private final Map<ArchiveInfo, Integer> mOrders = new HashMap<ArchiveInfo, Integer>();

        private InstallOrderComparator() {
        }

        @Override
        public int compare(ArchiveInfo o1, ArchiveInfo o2) {
            int n1 = this.getDependencyOrder(o1);
            int n2 = this.getDependencyOrder(o2);
            return n1 - n2;
        }

        private int getDependencyOrder(ArchiveInfo ai) {
            if (ai == null) {
                return 0;
            }
            Integer cached = this.mOrders.get(ai);
            if (cached != null) {
                return cached;
            }
            ArchiveInfo[] deps = ai.getDependsOn();
            if (deps == null) {
                return 0;
            }
            int n = deps.length;
            for (ArchiveInfo dep : deps) {
                n += this.getDependencyOrder(dep);
            }
            this.mOrders.put(ai, n);
            return n;
        }
    }
}

