/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.sdk.wizard.SmwOldApiDirectInstall;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class SdkQuickfixWizard
extends DynamicWizard {
    private final List<IPkgDesc> myRequestedPackages;
    private boolean myIsExiting = false;

    public SdkQuickfixWizard(Project project, Module module, List<IPkgDesc> requestedPackages) {
        this(project, module, requestedPackages, new DialogWrapperHost(project));
    }

    public SdkQuickfixWizard(Project project, Module module, List<IPkgDesc> requestedPackages, DialogWrapperHost host) {
        super(project, module, "SDK Quickfix Installation", host);
        this.myRequestedPackages = requestedPackages;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void init() {
        ScopedStateStore state = this.getState();
        this.addPath(new SdkQuickfixPath(this.getDisposable()));
        Set<IPkgDesc> problems = this.findProblemPackages();
        int selectedOption = 1;
        if (!problems.isEmpty()) {
            StringBuilder warningBuilder = new StringBuilder("Due to your system configuration and the packages to be installed, \nit is likely that the following packages cannot be successfully installed while ");
            warningBuilder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            warningBuilder.append(" is running. \n\nPlease exit and install the following packages using the standalone SDK manager:");
            for (IPkgDesc problemPkg : problems) {
                warningBuilder.append("\n    -");
                warningBuilder.append(problemPkg.getListDescription());
            }
            if (problems.size() == this.myRequestedPackages.size()) {
                selectedOption = Messages.showDialog((Project)this.getProject(), (String)warningBuilder.toString(), (String)"Warning", (String[])new String[]{String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName()), "Attempt to install packages"}, (int)0, (Icon)AllIcons.General.Warning);
            } else {
                String[] options = new String[]{String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName()), "Attempt to install all packages", "Install safe packages"};
                selectedOption = Messages.showDialog((Project)this.getProject(), (String)warningBuilder.toString(), (String)"Warning", (String[])options, (int)2, (Icon)AllIcons.General.Warning);
            }
        }
        if (selectedOption == 0) {
            this.startSdkManagerAndExit();
            this.myIsExiting = true;
            return;
        }
        for (IPkgDesc desc : this.myRequestedPackages) {
            if (selectedOption == 2 && problems.contains(desc)) {
                state.listPush(WizardConstants.SKIPPED_INSTALL_REQUESTS_KEY, desc);
                continue;
            }
            state.listPush(WizardConstants.INSTALL_REQUESTS_KEY, desc);
        }
        super.init();
    }

    @Override
    public boolean showAndGet() {
        if (this.myIsExiting) {
            Disposer.dispose((Disposable)this.myHost.getDisposable());
            return false;
        }
        return super.showAndGet();
    }

    @Override
    public void show() {
        if (this.myIsExiting) {
            Disposer.dispose((Disposable)this.myHost.getDisposable());
            return;
        }
        super.show();
    }

    private void startSdkManagerAndExit() {
        RunAndroidSdkManagerAction.runSpecificSdkManagerSynchronously(this.getProject(), AndroidSdkUtils.tryToChooseAndroidSdk().getLocation());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManagerEx.getApplicationEx().exit(true, true);
            }
        });
    }

    private Set<IPkgDesc> findProblemPackages() {
        HashSet result = Sets.newHashSet();
        if (!SystemInfo.isWindows) {
            return result;
        }
        SdkState state = SdkState.getInstance(AndroidSdkUtils.tryToChooseAndroidSdk());
        state.loadSynchronously(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, null, null, false);
        HashSet available = Sets.newHashSet();
        for (UpdatablePkgInfo update : state.getPackages().getUpdatedPkgs()) {
            if (update.hasRemote(false)) {
                available.add(update.getRemote(false).getPkgDesc().getInstallId());
            }
            if (!update.hasPreview()) continue;
            available.add(update.getRemote(true).getPkgDesc().getInstallId());
        }
        for (IPkgDesc request : this.myRequestedPackages) {
            if (!available.contains(request.getInstallId())) continue;
            result.add(request);
        }
        return result;
    }

    @Override
    public void performFinishingActions() {
        List<IPkgDesc> skipped = this.myState.get(WizardConstants.SKIPPED_INSTALL_REQUESTS_KEY);
        if (skipped != null && !skipped.isEmpty()) {
            final StringBuilder warningBuilder = new StringBuilder("The following packages were not installed.\n\n Would you like to exit ");
            warningBuilder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            warningBuilder.append(" and install the following packages using the standalone SDK manager?");
            for (IPkgDesc problemPkg : skipped) {
                warningBuilder.append("\n");
                warningBuilder.append(problemPkg.getListDescription());
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    String restartOption = String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName());
                    int result = Messages.showDialog((Project)SdkQuickfixWizard.this.getProject(), (String)warningBuilder.toString(), (String)"Warning", (String[])new String[]{restartOption, "Skip installation"}, (int)0, (Icon)AllIcons.General.Warning);
                    if (result == 0) {
                        SdkQuickfixWizard.this.startSdkManagerAndExit();
                    }
                }
            });
        }
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        SdkState.getInstance(data).loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, null, null, true);
    }

    @Override
    protected String getProgressTitle() {
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return "Provides a method for handling quickfix SDK installation actions";
    }

    private static class SdkQuickfixPath
    extends DynamicWizardPath {
        private Disposable myDisposable;
        private LicenseAgreementStep myLicenseAgreementStep;

        public SdkQuickfixPath(Disposable disposable) {
            this.myDisposable = disposable;
        }

        @Override
        protected void init() {
            this.myLicenseAgreementStep = new LicenseAgreementStep(this.myDisposable);
            this.addStep(this.myLicenseAgreementStep);
            this.addStep(new SmwOldApiDirectInstall(this.myDisposable));
        }

        @Override
        public String getPathName() {
            return "SDK Installation Quickfix";
        }

        @Override
        public boolean performFinishingActions() {
            this.myLicenseAgreementStep.performFinishingActions();
            return true;
        }
    }
}

