/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;

public final class Actions {
    private Actions() {
    }

    public static void hideAction(String actionId) {
        AnAction oldAction = ActionManager.getInstance().getAction(actionId);
        if (oldAction != null) {
            Actions.replaceAction(actionId, (AnAction)new EmptyAction());
        }
    }

    public static void replaceAction(String actionId, AnAction newAction) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction oldAction = actionManager.getAction(actionId);
        if (oldAction != null) {
            newAction.getTemplatePresentation().setIcon(oldAction.getTemplatePresentation().getIcon());
            actionManager.unregisterAction(actionId);
        }
        actionManager.registerAction(actionId, newAction);
    }

    public static void moveAction(String actionId, String oldGroupId, String groupId, Constraints constraints) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction(actionId);
        AnAction group = actionManager.getAction(groupId);
        AnAction oldGroup = actionManager.getAction(oldGroupId);
        if (action != null && oldGroup != null && group != null && oldGroup instanceof DefaultActionGroup && group instanceof DefaultActionGroup) {
            ((DefaultActionGroup)oldGroup).getChildren(null);
            ((DefaultActionGroup)oldGroup).remove(action);
            ((DefaultActionGroup)group).add(action, constraints);
        }
    }
}

