/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.stats.UsageUploader;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Map;

public class UsageTrackerAnalyticsImpl
extends UsageTracker {
    private static final ExtensionPointName<UsageUploader> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.stats.tracker");
    private static final String GLOGS_CATEGORY_LIBCOUNT = "gradlelibs";
    private final UsageUploader myUploader;

    public UsageTrackerAnalyticsImpl() {
        UsageUploader[] uploaders = (UsageUploader[])EP_NAME.getExtensions();
        this.myUploader = uploaders.length > 0 ? uploaders[0] : null;
    }

    private boolean trackingEnabled() {
        return this.myUploader != null && this.canTrack();
    }

    @Override
    public void trackEvent(String eventCategory, String eventAction, String eventLabel, Integer eventValue) {
        if (!this.trackingEnabled()) {
            return;
        }
        this.myUploader.trackEvent(eventCategory, eventAction, eventLabel, eventValue);
    }

    @Override
    public void trackLibraryCount(String applicationId, int jarDependencyCount, int aarDependencyCount) {
        if (!this.trackingEnabled()) {
            return;
        }
        String anonymizedId = Hashing.md5().hashString((CharSequence)applicationId, Charsets.UTF_8).toString();
        this.myUploader.trackEvent(GLOGS_CATEGORY_LIBCOUNT, (Map<String, String>)ImmutableMap.of((Object)"appId", (Object)anonymizedId, (Object)"jars", (Object)Integer.toString(jarDependencyCount), (Object)"aars", (Object)Integer.toString(aarDependencyCount)));
    }
}

