/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceCreator;
import com.android.tools.idea.structure.services.DeveloperServiceCreators;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;

public final class DeveloperServices {
    private static final Logger LOG = Logger.getInstance(DeveloperService.class);
    private static Multimap<Module, DeveloperService> ourServices = ArrayListMultimap.create();

    public static Iterable<DeveloperService> getAll(Module module) {
        DeveloperServices.initializeFor(module);
        return ourServices.get((Object)module);
    }

    public static Iterable<DeveloperService> getFor(Module module, final ServiceCategory category) {
        return Iterables.filter(DeveloperServices.getAll(module), (Predicate)new Predicate<DeveloperService>(){

            public boolean apply(DeveloperService service) {
                return service.getCategory() == category;
            }
        });
    }

    private static void initializeFor(final Module module) {
        if (ourServices.containsKey((Object)module)) {
            return;
        }
        for (DeveloperServiceCreators creators : (DeveloperServiceCreators[])DeveloperServiceCreators.EP_NAME.getExtensions()) {
            try {
                for (DeveloperServiceCreator developerServiceCreator : creators.getCreators()) {
                    DeveloperService service = developerServiceCreator.createService(module);
                    if (service == null) continue;
                    ourServices.put((Object)module, (Object)service);
                }
            }
            catch (Exception e) {
                LOG.warn("Caught exception while initializing services", (Throwable)e);
            }
        }
        BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).initializeServices(module, new Runnable(){

            @Override
            public void run() {
                for (DeveloperService service : ourServices.get((Object)module)) {
                    service.updateInstalledState();
                }
            }
        });
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleRemoved(Project project, Module moduleRemoved) {
                if (module == moduleRemoved) {
                    ourServices.removeAll((Object)module);
                }
            }
        });
    }
}

