/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.Observable;
import com.android.tools.idea.ui.properties.ObservableProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.EmptyRunnable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;

public final class ServiceContext {
    private final Map<String, Observable> myValues = Maps.newHashMap();
    private final Map<String, Runnable> myActions = Maps.newHashMap();
    private final Map<ObservableProperty, Object> myWatched = new WeakHashMap<ObservableProperty, Object>();
    private final BoolValueProperty myInstalled = new BoolValueProperty();
    private final BoolValueProperty myModified = new BoolValueProperty();
    private final InvalidationListener myWatchedListener = new InvalidationListener(){

        @Override
        protected void onInvalidated(Observable sender) {
            ServiceContext.this.myModified.set(true);
        }
    };
    private final String myBuildSystemId;
    private Runnable myBeforeShown = EmptyRunnable.INSTANCE;
    private Callable<Boolean> myTestValidity = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return true;
        }
    };

    public ServiceContext(String buildSystemId) {
        this.myBuildSystemId = buildSystemId;
    }

    String getBuildSystemId() {
        return this.myBuildSystemId;
    }

    public void setBeforeShownCallback(Runnable beforeShown) {
        this.myBeforeShown = beforeShown;
    }

    public void setIsValidCallback(Callable<Boolean> testValidity) {
        this.myTestValidity = testValidity;
    }

    public void beginEditing() {
        this.myBeforeShown.run();
        if (this.myWatched.isEmpty()) {
            this.myModified.set(this.isValid());
        }
    }

    public void finishEditing() {
        if (!this.myModified.get().booleanValue()) {
            return;
        }
        this.myModified.set(this.isValid());
    }

    public void cancelEditing() {
        this.myModified.set(false);
    }

    public BoolValueProperty installed() {
        return this.myInstalled;
    }

    public ObservableBool modified() {
        return this.myModified;
    }

    public void snapshot() {
        for (ObservableProperty property : this.myWatched.keySet()) {
            this.myWatched.put(property, property.get());
        }
        this.myModified.set(false);
    }

    public void restore() {
        for (ObservableProperty property : this.myWatched.keySet()) {
            property.set(this.myWatched.get(property));
        }
        this.myModified.set(false);
    }

    public void putValue(String key, Observable observable) {
        this.myValues.put(key, observable);
    }

    public void putWatchedValue(String key, ObservableProperty property) {
        this.putValue(key, property);
        property.addWeakListener(this.myWatchedListener);
        this.myWatched.put(property, property.get());
    }

    public void putAction(String key, Runnable action) {
        this.myActions.put(key, action);
    }

    public Observable getValue(String key) {
        Observable value = this.myValues.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Service context: Value \"%1$s\" not found.", key));
        }
        return value;
    }

    public Runnable getAction(String key) {
        Runnable action = this.myActions.get(key);
        if (action == null) {
            throw new IllegalArgumentException(String.format("Service context: Action \"%1$s\" not found.", key));
        }
        return action;
    }

    public Map<String, Object> toValueMap() {
        HashMap valueMap = Maps.newHashMap();
        Splitter splitter = Splitter.on((char)'.');
        for (String key : this.myValues.keySet()) {
            Observable value = this.getValue(key);
            Map currLevel = valueMap;
            Iterator keyParts = splitter.split((CharSequence)key).iterator();
            while (keyParts.hasNext()) {
                String keyPart = (String)keyParts.next();
                if (keyParts.hasNext()) {
                    if (currLevel.containsKey(keyPart)) {
                        currLevel = (Map)currLevel.get(keyPart);
                        continue;
                    }
                    HashMap nextLevel = Maps.newHashMap();
                    currLevel.put(keyPart, nextLevel);
                    currLevel = nextLevel;
                    continue;
                }
                currLevel.put(keyPart, value);
            }
        }
        return valueMap;
    }

    private boolean isValid() {
        try {
            return this.myTestValidity.call();
        }
        catch (Exception e) {
            return false;
        }
    }
}

