/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.FMGetApplicationThemeMethod;
import com.android.tools.idea.templates.FmActivityToLayoutMethod;
import com.android.tools.idea.templates.FmCamelCaseToUnderscoreMethod;
import com.android.tools.idea.templates.FmClassNameToResourceMethod;
import com.android.tools.idea.templates.FmCompareVersionsMethod;
import com.android.tools.idea.templates.FmEscapePropertyValueMethod;
import com.android.tools.idea.templates.FmEscapeXmlAttributeMethod;
import com.android.tools.idea.templates.FmEscapeXmlStringMethod;
import com.android.tools.idea.templates.FmExtractLettersMethod;
import com.android.tools.idea.templates.FmHasDependencyMethod;
import com.android.tools.idea.templates.FmLayoutToActivityMethod;
import com.android.tools.idea.templates.FmSlashedPackageNameMethod;
import com.android.tools.idea.templates.FmTruncateStringMethod;
import com.android.tools.idea.templates.FmUnderscoreToCamelCaseMethod;
import com.android.tools.idea.templates.StudioTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class FreemarkerUtils {
    public static Map<String, Object> createParameterMap(Map<String, Object> args) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("slashedPackageName", new FmSlashedPackageNameMethod());
        paramMap.put("camelCaseToUnderscore", new FmCamelCaseToUnderscoreMethod());
        paramMap.put("underscoreToCamelCase", new FmUnderscoreToCamelCaseMethod());
        paramMap.put("activityToLayout", new FmActivityToLayoutMethod());
        paramMap.put("layoutToActivity", new FmLayoutToActivityMethod());
        paramMap.put("classToResource", new FmClassNameToResourceMethod());
        paramMap.put("escapeXmlAttribute", new FmEscapeXmlAttributeMethod());
        paramMap.put("escapeXmlText", new FmEscapeXmlStringMethod());
        paramMap.put("escapeXmlString", new FmEscapeXmlStringMethod());
        paramMap.put("escapePropertyValue", new FmEscapePropertyValueMethod());
        paramMap.put("extractLetters", new FmExtractLettersMethod());
        paramMap.put("hasDependency", new FmHasDependencyMethod(paramMap));
        paramMap.put("truncate", new FmTruncateStringMethod());
        paramMap.put("compareVersions", new FmCompareVersionsMethod());
        paramMap.put("getApplicationTheme", new FMGetApplicationThemeMethod(paramMap));
        paramMap.put("dependencyList", new LinkedList());
        paramMap.putAll(args);
        return paramMap;
    }

    public static String processFreemarkerTemplate(Configuration freemarker, Map<String, Object> paramMap, File file, TemplatePostProcessor processor) throws TemplateProcessingException {
        StudioTemplateLoader loader = (StudioTemplateLoader)freemarker.getTemplateLoader();
        File previousFolder = loader.getTemplateFolder();
        try {
            file = loader.getSourceFile(file);
            loader.setTemplateFolder(file.getParentFile());
            Template template = freemarker.getTemplate(file.getName());
            StringWriter out = new StringWriter();
            template.process(paramMap, (Writer)out);
            out.flush();
            String content = out.toString().replace("\r", "");
            if (processor != null) {
                processor.process(content);
            }
            String string = content;
            return string;
        }
        catch (TemplateException ex) {
            throw new TemplateProcessingException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new TemplateProcessingException(ex);
        }
        finally {
            loader.setTemplateFolder(previousFolder);
        }
    }

    public static class TemplateProcessingException
    extends Exception {
        public TemplateProcessingException(Exception inner) {
            super(inner);
        }
    }

    public static interface TemplatePostProcessor {
        public void process(String var1) throws TemplateProcessingException;
    }
}

