/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class KeystoreUtils {
    public static File getDebugKeystore(AndroidFacet facet) throws Exception {
        File gradleDebugKeystore = KeystoreUtils.getGradleDebugKeystore(facet);
        if (gradleDebugKeystore != null) {
            return gradleDebugKeystore;
        }
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)facet.getConfiguration()).getState();
        if (state != null && !Strings.isNullOrEmpty((String)state.CUSTOM_DEBUG_KEYSTORE_PATH)) {
            return new File(state.CUSTOM_DEBUG_KEYSTORE_PATH);
        }
        return KeystoreUtils.getOrCreateDefaultDebugKeystore();
    }

    public static File getOrCreateDefaultDebugKeystore() throws Exception {
        try {
            File debugLocation = new File(KeystoreHelper.defaultDebugKeystoreLocation());
            if (!debugLocation.exists()) {
                StdLogger logger = new StdLogger(StdLogger.Level.ERROR);
                KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)logger);
            }
            if (!debugLocation.exists()) {
                throw new AndroidLocation.AndroidLocationException("Could not create debug keystore");
            }
            return debugLocation;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            throw new Exception("Failed to get debug keystore path", e);
        }
    }

    private static File getGradleDebugKeystore(AndroidFacet facet) {
        GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(facet.getModule().getProject());
        if (gradleSettingsFile == null) {
            return null;
        }
        String modulePath = GradleSettingsFile.getModuleGradlePath(facet.getModule());
        if (modulePath == null) {
            return null;
        }
        final GradleBuildFile moduleBuildFile = gradleSettingsFile.getModuleBuildFile(modulePath);
        if (moduleBuildFile == null) {
            return null;
        }
        Iterable signingConfigs = (Iterable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Iterable<NamedObject>>(){

            public Iterable<NamedObject> compute() {
                return (Iterable)moduleBuildFile.getValue(BuildFileKey.SIGNING_CONFIGS);
            }
        });
        if (signingConfigs == null) {
            return null;
        }
        for (NamedObject namedObject : signingConfigs) {
            VirtualFile moduleFile;
            File debugKey;
            if (!"debug".equals(namedObject.getName()) || (debugKey = (File)namedObject.getValue(BuildFileKey.STORE_FILE)) == null || (moduleFile = facet.getModule().getModuleFile()) == null) continue;
            return new File(moduleFile.getParent().getPath(), debugKey.getPath());
        }
        return null;
    }

    public static String sha1(File keystoreFile) throws Exception {
        Certificate signingCert;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(keystoreFile), "android".toCharArray());
            String keyAlias = keyStore.aliases().nextElement();
            signingCert = keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            throw new Exception("Could not extract certificate from file.", e);
        }
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            return BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
        }
        catch (Exception e) {
            throw new Exception("Could not compute SHA1 hash from certificate", e);
        }
    }
}

