/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.utils.SdkUtils;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class StudioTemplateLoader
implements TemplateLoader {
    private File myTemplateFolder;

    public StudioTemplateLoader(File folder) {
        this.myTemplateFolder = folder;
    }

    public void setTemplateFolder(File folder) {
        this.myTemplateFolder = folder;
    }

    public File getTemplateFolder() {
        return this.myTemplateFolder;
    }

    public File getSourceFile(File file) throws IOException {
        if (file.isAbsolute()) {
            return file;
        }
        file = new File(this.myTemplateFolder, file.getPath());
        return file.getCanonicalFile();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        InputStream stream = (InputStream)templateSource;
        return new InputStreamReader(stream, encoding);
    }

    public long getLastModified(Object templateSource) {
        return -1L;
    }

    public Object findTemplateSource(String name) throws IOException {
        File file = new File(this.myTemplateFolder, name);
        if (file.exists()) {
            return SdkUtils.fileToUrl((File)file).openStream();
        }
        return null;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((InputStream)templateSource).close();
    }
}

