/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeContext;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Template {
    public static final String TEMPLATE_XML_NAME = "template.xml";
    public static final String TAG_EXECUTE = "execute";
    public static final String TAG_GLOBALS = "globals";
    public static final String TAG_GLOBAL = "global";
    public static final String TAG_PARAMETER = "parameter";
    public static final String TAG_THUMB = "thumb";
    public static final String TAG_THUMBS = "thumbs";
    public static final String TAG_DEPENDENCY = "dependency";
    public static final String TAG_ICONS = "icons";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_HELP = "help";
    public static final String ATTR_FILE = "file";
    public static final String ATTR_CONSTRAINTS = "constraints";
    public static final String ATTR_VISIBILITY = "visibility";
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_SOURCE_URL = "href";
    public static final String CATEGORY_ACTIVITIES = "activities";
    public static final String CATEGORY_ACTIVITY = "Activity";
    public static final String CATEGORY_PROJECTS = "gradle-projects";
    public static final String CATEGORY_OTHER = "other";
    public static final String CATEGORY_APPLICATION = "Application";
    public static final String BLOCK_DEPENDENCIES = "dependencies";
    static final int CURRENT_FORMAT = 5;
    static final int RELATIVE_FILES_FORMAT = 5;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.Template");
    public static Exception ourMostRecentException;
    private final List<File> myFilesToOpen = Lists.newArrayList();
    private final File myTemplateRoot;
    private final StudioTemplateLoader myLoader;
    private TemplateMetadata myMetadata;
    private Project myProject;

    private Template(File rootPath) {
        this.myTemplateRoot = rootPath;
        this.myLoader = new StudioTemplateLoader(this.myTemplateRoot);
    }

    public static Template createFromPath(File rootPath) {
        return new Template(rootPath);
    }

    public static Template createFromName(String category, String name) {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplates(category);
        for (File file : templates) {
            if (!file.getName().equals(name) || !category.equals(file.getParentFile().getName())) continue;
            return new Template(file);
        }
        return new Template(new File(TemplateManager.getTemplateRootFolder(), category + File.separator + name));
    }

    public static Map<String, Object> createParameterMap(Map<String, Object> args) {
        Map<String, Object> paramMap = FreemarkerUtils.createParameterMap(args);
        if (ApplicationManager.getApplication() != null && TemplateManager.getTemplateRootFolder() != null) {
            paramMap.put("templateRoot", TemplateManager.getTemplateRootFolder().getAbsolutePath());
        }
        return paramMap;
    }

    private static void enforceParameterTypes(TemplateMetadata metadata, Map<String, Object> args) {
        for (Parameter p : metadata.getParameters()) {
            Object o = args.get(p.id);
            if (o == null) continue;
            switch (p.type) {
                case STRING: {
                    if (o instanceof String) break;
                    args.put(p.id, o.toString());
                    break;
                }
                case BOOLEAN: {
                    if (o instanceof Boolean) break;
                    args.put(p.id, Boolean.parseBoolean(o.toString()));
                    break;
                }
                case ENUM: {
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case EXTERNAL: {
                    break;
                }
            }
        }
        Template.convertApisToInt(args);
    }

    public static void convertApisToInt(Map<String, Object> args) {
        Template.convertToInt("buildApi", args);
        Template.convertToInt("minApiLevel", args);
        Template.convertToInt("targetApi", args);
    }

    private static void convertToInt(String key, Map<String, Object> args) {
        Object value = args.get(key);
        if (value instanceof String) {
            Integer result;
            try {
                result = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                result = SdkVersionInfo.getApiByPreviewName((String)((String)value), (boolean)true);
            }
            args.put(key, result);
        }
    }

    @Deprecated
    public void render(File outputRootPath, File moduleRootPath, Map<String, Object> args) {
        this.render(outputRootPath, moduleRootPath, args, null);
    }

    public void render(File outputRootPath, File moduleRootPath, Map<String, Object> args, Project project) {
        this.render(outputRootPath, moduleRootPath, args, project, true);
    }

    public void render(final File outputRootPath, final File moduleRootPath, final Map<String, Object> args, final Project project, final boolean gradleSyncIfNeeded) {
        assert (outputRootPath.isDirectory()) : outputRootPath;
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                Template.this.doRender(outputRootPath, moduleRootPath, args, project, gradleSyncIfNeeded);
            }
        });
        String title = this.myMetadata.getTitle();
        if (title != null) {
            UsageTracker.getInstance().trackEvent("template", "render", title, null);
        }
    }

    private void doRender(File outputRootPath, File moduleRootPath, Map<String, Object> args, Project project, boolean gradleSyncIfNeeded) {
        this.myFilesToOpen.clear();
        if (project == null) {
            project = ProjectManagerEx.getInstanceEx().getDefaultProject();
        }
        this.myProject = project;
        Map<String, Object> paramMap = Template.createParameterMap(args);
        Template.enforceParameterTypes(this.getMetadata(), args);
        FreemarkerConfiguration freemarker = new FreemarkerConfiguration();
        freemarker.setTemplateLoader(this.myLoader);
        this.processFile(freemarker, new File(TEMPLATE_XML_NAME), paramMap, outputRootPath, moduleRootPath, gradleSyncIfNeeded);
    }

    public File getRootPath() {
        return this.myTemplateRoot;
    }

    public TemplateMetadata getMetadata() {
        if (this.myMetadata == null) {
            this.myMetadata = TemplateManager.getInstance().getTemplate(this.myTemplateRoot);
        }
        return this.myMetadata;
    }

    public List<File> getFilesToOpen() {
        return this.myFilesToOpen;
    }

    private void processFile(final Configuration freemarker, File file, final Map<String, Object> paramMap, final File outputRoot, final File moduleRoot, final boolean gradleSyncIfNeeded) {
        try {
            if (TemplateUtils.hasExtension(file, ".xml")) {
                String xml = TemplateUtils.readTextFile(this.getTemplateFile(file));
                if (xml == null) {
                    return;
                }
                this.processXml(xml, freemarker, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
            } else {
                FreemarkerUtils.processFreemarkerTemplate(freemarker, paramMap, file, new FreemarkerUtils.TemplatePostProcessor(){

                    @Override
                    public void process(String xml) throws FreemarkerUtils.TemplateProcessingException {
                        Template.this.processXml(xml, freemarker, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
                    }
                });
            }
        }
        catch (Exception e) {
            ourMostRecentException = e;
            LOG.warn((Throwable)e);
        }
    }

    private void processXml(String xml, final Configuration freemarker, final Map<String, Object> paramMap, final File outputRoot, final File moduleRoot, final boolean gradleSyncIfNeeded) throws FreemarkerUtils.TemplateProcessingException {
        try {
            xml = XmlUtils.stripBom((String)xml);
            InputSource inputSource = new InputSource(new StringReader(xml));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                    if (Template.TAG_PARAMETER.equals(name)) {
                        String id = attributes.getValue(Template.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            String type;
                            String value = attributes.getValue(Template.ATTR_DEFAULT);
                            Object mapValue = value;
                            if (value != null && !value.isEmpty() && "boolean".equals(type = attributes.getValue(Template.ATTR_TYPE))) {
                                mapValue = Boolean.valueOf(value);
                            }
                            paramMap.put(id, mapValue);
                        }
                    } else if (Template.TAG_GLOBAL.equals(name)) {
                        String id = attributes.getValue(Template.ATTR_ID);
                        if (!paramMap.containsKey(id)) {
                            paramMap.put(id, TypedVariable.parseGlobal(attributes));
                        }
                    } else if (Template.TAG_GLOBALS.equals(name)) {
                        File globalsFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                        if (globalsFile != null) {
                            Template.this.processFile(freemarker, globalsFile, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
                        }
                    } else if (Template.TAG_EXECUTE.equals(name)) {
                        File recipeFile = SaxUtils.getPath(attributes, Template.ATTR_FILE);
                        if (recipeFile != null) {
                            Template.this.executeRecipeFile(freemarker, recipeFile, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
                        }
                    } else if (!(name.equals("template") || name.equals("category") || name.equals("option") || name.equals(Template.TAG_THUMBS) || name.equals(Template.TAG_THUMB) || name.equals(Template.TAG_ICONS) || name.equals(Template.TAG_DEPENDENCY) || name.equals("formfactor"))) {
                        LOG.error("WARNING: Unknown template directive " + name);
                    }
                }
            });
        }
        catch (SAXException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
        catch (IOException ex) {
            throw new FreemarkerUtils.TemplateProcessingException(ex);
        }
    }

    private void executeRecipeFile(final Configuration freemarker, File fileRecipe, final Map<String, Object> paramMap, final File outputRoot, final File moduleRoot, final boolean gradleSyncIfNeeded) {
        try {
            FreemarkerUtils.processFreemarkerTemplate(freemarker, paramMap, fileRecipe, new FreemarkerUtils.TemplatePostProcessor(){

                @Override
                public void process(String xml) throws FreemarkerUtils.TemplateProcessingException {
                    try {
                        xml = XmlUtils.stripBom((String)xml);
                        Recipe recipe = Recipe.parse(new StringReader(xml));
                        Template.this.myFilesToOpen.addAll(recipe.getFilesToOpen());
                        RecipeContext recipeContext = new RecipeContext(Template.this.myProject, Template.this.myLoader, freemarker, paramMap, outputRoot, moduleRoot, gradleSyncIfNeeded);
                        if (Template.this.getMetadata().useImplicitRootFolder()) {
                            Template.this.myLoader.setTemplateFolder(new File(Template.this.myLoader.getTemplateFolder(), "root"));
                        }
                        recipe.execute(recipeContext);
                    }
                    catch (JAXBException ex) {
                        throw new FreemarkerUtils.TemplateProcessingException((Exception)((Object)ex));
                    }
                }
            });
        }
        catch (Exception e) {
            ourMostRecentException = e;
            LOG.warn((Throwable)e);
        }
    }

    private File getTemplateFile(File relativeFile) throws IOException {
        return new File(this.myTemplateRoot, relativeFile.getPath());
    }
}

