/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.npw.WizardUtils;
import com.android.utils.SparseArray;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");

    public static String extractClassName(String string) {
        char c;
        int i;
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        for (i = 0; i < n; ++i) {
            c = Character.toUpperCase(string.charAt(i));
            if (!Character.isJavaIdentifierStart(c)) continue;
            sb.append(c);
            ++i;
            break;
        }
        if (sb.length() > 0) {
            while (i < n) {
                c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    public static String stripSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static File stripSuffix(File file, String suffix) {
        if (file.getName().endsWith(suffix)) {
            String name = file.getName();
            name = name.substring(0, name.length() - suffix.length());
            File parent = file.getParentFile();
            if (parent != null) {
                return new File(parent, name);
            }
            return new File(name);
        }
        return file;
    }

    public static String camelCaseToUnderlines(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append('_');
            }
            lastWasUpperCase = isUpperCase;
            c = Character.toLowerCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlinesToCamelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        boolean upcaseNext = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                upcaseNext = true;
                continue;
            }
            if (upcaseNext) {
                c = Character.toUpperCase(c);
            }
            upcaseNext = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] getKnownVersions() {
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        assert (sdkData != null);
        int max = 23;
        IAndroidTarget[] targets = sdkData.getTargets();
        SparseArray apiTargets = null;
        for (IAndroidTarget target : targets) {
            AndroidVersion version;
            if (!target.isPlatform() || (version = target.getVersion()).isPreview()) continue;
            int apiLevel = version.getApiLevel();
            max = Math.max(max, apiLevel);
            if (apiLevel <= 23) continue;
            if (apiTargets == null) {
                apiTargets = new SparseArray();
            }
            apiTargets.put(apiLevel, (Object)target);
        }
        String[] versions = new String[max];
        for (int api = 1; api <= max; ++api) {
            String name = SdkVersionInfo.getAndroidName((int)api);
            if (name == null) {
                IAndroidTarget target;
                if (apiTargets != null && (target = (IAndroidTarget)apiTargets.get(api)) != null) {
                    name = AndroidSdkUtils.getTargetLabel(target);
                }
                if (name == null) {
                    name = String.format("API %1$d", api);
                }
            }
            versions[api - 1] = name;
        }
        return versions;
    }

    public static File[] listFiles(File dir) {
        return WizardUtils.listFiles(dir);
    }

    public static List<Element> getChildren(Element element) {
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(children.getLength());
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            result.add(child);
        }
        return result;
    }

    public static boolean openEditors(Project project, List<File> files, boolean select) {
        if (files.size() > 0) {
            boolean result = true;
            VirtualFile last = null;
            for (File file : files) {
                if (!file.exists()) continue;
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                if (vFile != null) {
                    result &= TemplateUtils.openEditor(project, vFile);
                    last = vFile;
                    continue;
                }
                result = false;
            }
            if (select && last != null) {
                TemplateUtils.selectEditor(project, last);
            }
            return result;
        }
        return false;
    }

    public static boolean openEditor(Project project, VirtualFile vFile) {
        OpenFileDescriptor descriptor = vFile.getFileType() == StdFileTypes.XML && AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? new OpenFileDescriptor(project, vFile, 0) : new OpenFileDescriptor(project, vFile);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor, true).isEmpty();
    }

    public static void selectEditor(Project project, VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile != null) {
            ProjectPaneSelectInTarget selectAction = new ProjectPaneSelectInTarget(project);
            selectAction.select((PsiElement)psiFile, false);
        }
    }

    public static String readTextFile(File file, boolean warnIfNotExists) {
        assert (file.isAbsolute());
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    public static String readTextFile(File file) {
        return TemplateUtils.readTextFile(file, true);
    }

    public static String readTextFile(final Project project, final VirtualFile file) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) {
                    return null;
                }
                return psiFile.getText();
            }
        });
    }

    public static void writeFile(Object requestor, String contents, File to) throws IOException {
        Document document;
        if (contents == null) {
            return;
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(to);
        if (vf == null) {
            VirtualFile parentDir = TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            vf = parentDir.createChildData(requestor, to.getName());
        }
        if ((document = FileDocumentManager.getInstance().getDocument(vf)) != null) {
            document.setText((CharSequence)contents.replaceAll("\r\n", "\n"));
            FileDocumentManager.getInstance().saveDocument(document);
        } else {
            vf.setBinaryContent(contents.getBytes(Charsets.UTF_8), -1L, -1L, requestor);
        }
    }

    public static VirtualFile checkedCreateDirectoryIfMissing(final File directory) throws IOException {
        return (VirtualFile)WriteCommandAction.runWriteCommandAction(null, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)directory.getAbsolutePath());
                if (dir == null) {
                    throw new IOException("Unable to create " + directory.getAbsolutePath());
                }
                return dir;
            }
        });
    }

    public static boolean hasExtension(File file, String extension) {
        String noDotExtension = extension.startsWith(".") ? extension.substring(1) : extension;
        return Files.getFileExtension((String)file.getName()).equalsIgnoreCase(noDotExtension);
    }
}

