/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import org.xml.sax.Attributes;

public class TypedVariable {
    private static final Logger LOG = Logger.getInstance(TypedVariable.class);

    public static Object parse(Type type, String value) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return value;
            }
            case BOOLEAN: {
                if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case INTEGER: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error("NumberFormatException while evaluating " + value);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static Object parseGlobal(Attributes attributes) {
        String value = attributes.getValue("value");
        Type type = Type.get(attributes.getValue("type"));
        Object result = TypedVariable.parse(type, value);
        return result != null ? result : value;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INTEGER;


        public static Type get(String name) {
            if (name == null) {
                return STRING;
            }
            try {
                return Type.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error("Unexpected global type '" + name + "'");
                    LOG.error("Expected one of :");
                    for (Type s : Type.values()) {
                        LOG.error("  " + s.name().toLowerCase(Locale.US));
                    }
                }
                return STRING;
            }
        }
    }
}

