/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.parse.StringFileAdapter;
import com.android.tools.idea.templates.recipe.RecipeContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="recipe")
public final class Recipe {
    @XmlElements(value={@XmlElement(name="copy", type=CopyInstruction.class), @XmlElement(name="instantiate", type=InstantiateInstruction.class), @XmlElement(name="merge", type=MergeInstruction.class), @XmlElement(name="mkdir", type=MkDirInstruction.class), @XmlElement(name="dependency", type=DependencyInstruction.class), @XmlElement(name="open", type=OpenInstruction.class), @XmlElement(name="execute", type=ExecuteInstruction.class)})
    private List<RecipeInstruction> instructions = Lists.newArrayList();
    private final List<String> myDependencies = Lists.newArrayList();
    private final List<File> mySourceFiles = Lists.newArrayList();
    private final List<File> myTargetFiles = Lists.newArrayList();
    private final List<File> myFilesToOpen = Lists.newArrayList();

    public List<String> getDependencies() {
        return this.myDependencies;
    }

    public List<File> getSourceFiles() {
        return this.mySourceFiles;
    }

    public List<File> getTargetFiles() {
        return this.myTargetFiles;
    }

    public List<File> getFilesToOpen() {
        return this.myFilesToOpen;
    }

    public static Recipe parse(Reader xmlReader) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Recipe.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (Recipe)u.unmarshal(xmlReader);
    }

    private static File cloneWithourFreemarkerSuffix(File file) {
        File clone = new File(file.getPath());
        return TemplateUtils.stripSuffix(clone, ".ftl");
    }

    public void execute(RecipeContext recipeContext) {
        for (RecipeInstruction instruction : this.instructions) {
            instruction.execute(recipeContext);
        }
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        this.instructions.add(new FinalInstruction());
        for (RecipeInstruction instruction : this.instructions) {
            instruction.addDependenciesInto(this.myDependencies);
            instruction.addSourceFilesInto(this.mySourceFiles);
            instruction.addTargetFilesInto(this.myTargetFiles);
            instruction.addFilesToOpenInto(this.myFilesToOpen);
        }
    }

    private static final class FinalInstruction
    extends RecipeInstruction {
        private FinalInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.updateAndSyncGradle();
        }
    }

    private static final class ExecuteInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        private File file;

        private ExecuteInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.execute(this.file);
        }
    }

    private static final class DependencyInstruction
    extends RecipeInstruction {
        @XmlAttribute(required=true)
        private String mavenUrl;

        private DependencyInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.addDependency(this.mavenUrl);
        }

        @Override
        public void addDependenciesInto(List<String> dependencies) {
            dependencies.add(this.mavenUrl);
        }
    }

    private static final class OpenInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        private File file;

        private OpenInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.open(this.file);
        }

        @Override
        public void addFilesToOpenInto(List<File> files) {
            files.add(this.file);
        }
    }

    private static final class MkDirInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        private File at;

        private MkDirInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            context.mkDir(this.at);
        }
    }

    private static final class MergeInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        private File to;

        private MergeInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            assert (this.to != null);
            context.merge(this.from, this.to);
        }

        @Override
        public void addSourceFilesInto(List<File> files) {
            files.add(this.from);
        }

        @Override
        public void addTargetFilesInto(List<File> files) {
            files.add(this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithourFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class InstantiateInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        private File to;

        private InstantiateInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            assert (this.to != null);
            context.instantiate(this.from, this.to);
        }

        @Override
        public void addSourceFilesInto(List<File> files) {
            files.add(this.from);
        }

        @Override
        public void addTargetFilesInto(List<File> files) {
            files.add(this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithourFreemarkerSuffix(this.from);
            }
        }
    }

    private static final class CopyInstruction
    extends RecipeInstruction {
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute(required=true)
        private File from;
        @XmlJavaTypeAdapter(value=StringFileAdapter.class)
        @XmlAttribute
        private File to;

        private CopyInstruction() {
        }

        @Override
        public void execute(RecipeContext context) {
            assert (this.to != null);
            context.copy(this.from, this.to);
        }

        @Override
        public void addSourceFilesInto(List<File> files) {
            files.add(this.from);
        }

        @Override
        public void addTargetFilesInto(List<File> files) {
            files.add(this.to);
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.to == null || this.to.getPath().isEmpty()) {
                this.to = Recipe.cloneWithourFreemarkerSuffix(this.from);
            }
        }
    }

    private static abstract class RecipeInstruction {
        private RecipeInstruction() {
        }

        public abstract void execute(RecipeContext var1);

        public void addDependenciesInto(List<String> dependencies) {
        }

        public void addSourceFilesInto(List<File> files) {
        }

        public void addTargetFilesInto(List<File> files) {
        }

        public void addFilesToOpenInto(List<File> files) {
        }
    }
}

