/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.GradleFileMerger;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;

public final class RecipeContext {
    private static final Logger LOG = Logger.getInstance(RecipeContext.class);
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private final Project myProject;
    private final StudioTemplateLoader myLoader;
    private final Configuration myFreemarker;
    private final Map<String, Object> myParamMap;
    private final File myOutputRoot;
    private final File myModuleRoot;
    private final boolean mySyncGradleIfNeeded;
    private boolean myNeedsGradleSync;

    public RecipeContext(Project project, StudioTemplateLoader loader, Configuration freemarker, Map<String, Object> paramMap, File outputRoot, File moduleRoot, boolean syncGradleIfNeeded) {
        this.myProject = project;
        this.myLoader = loader;
        this.myFreemarker = freemarker;
        this.myParamMap = paramMap;
        this.myOutputRoot = outputRoot;
        this.myModuleRoot = moduleRoot;
        this.mySyncGradleIfNeeded = syncGradleIfNeeded;
    }

    public RecipeContext(Module module, StudioTemplateLoader loader, Configuration freemarker, Map<String, Object> paramMap, boolean syncGradleIfNeeded) {
        File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
        this.myProject = module.getProject();
        this.myLoader = loader;
        this.myFreemarker = freemarker;
        this.myParamMap = paramMap;
        this.myOutputRoot = moduleRoot;
        this.myModuleRoot = moduleRoot;
        this.mySyncGradleIfNeeded = syncGradleIfNeeded;
    }

    public void addDependency(String mavenUrl) {
        List dependencyList = (List)this.myParamMap.get("dependencyList");
        dependencyList.add(mavenUrl);
    }

    public void copy(File from, File to) {
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void instantiate(File from, File to) {
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                String contents = FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, from, null);
                contents = this.format(contents, to);
                File targetFile = this.getTargetFile(to);
                VfsUtil.createDirectories((String)targetFile.getParentFile().getAbsolutePath());
                TemplateUtils.writeFile(this, contents, targetFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void merge(File from, File to) {
        try {
            String contents;
            String sourceText;
            String targetText = null;
            to = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(to, ".xml") && !TemplateUtils.hasExtension(to, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + to);
            }
            if (to.exists()) {
                targetText = Files.toString((File)to, (Charset)Charsets.UTF_8);
            } else if (to.getParentFile() != null) {
                TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, to);
                } else {
                    this.copyTemplateResource(from, to);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, from, null);
            } else {
                sourceText = TemplateUtils.readTextFile(from = this.myLoader.getSourceFile(from));
                if (sourceText == null) {
                    return;
                }
            }
            if (to.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsGradleSync = true;
            } else if (to.getName().equals("build.gradle")) {
                String compileSdkVersion = (String)this.myParamMap.get("buildApiString");
                contents = GradleFileMerger.mergeGradleFiles(sourceText, targetText, this.myProject, compileSdkVersion);
                this.myNeedsGradleSync = true;
            } else if (TemplateUtils.hasExtension(to, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myProject, sourceText, targetText, to);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + to);
            }
            TemplateUtils.writeFile(this, contents, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void mkDir(File at) {
        try {
            TemplateUtils.checkedCreateDirectoryIfMissing(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void open(File file) {
    }

    public void execute(File file) {
        try {
            FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, file, new FreemarkerUtils.TemplatePostProcessor(){

                @Override
                public void process(String xml) throws FreemarkerUtils.TemplateProcessingException {
                    try {
                        xml = XmlUtils.stripBom((String)xml);
                        Recipe recipe = Recipe.parse(new StringReader(xml));
                        RecipeContext context = new RecipeContext(RecipeContext.this.myProject, RecipeContext.this.myLoader, RecipeContext.this.myFreemarker, RecipeContext.this.myParamMap, RecipeContext.this.myOutputRoot, RecipeContext.this.myModuleRoot, false);
                        recipe.execute(context);
                    }
                    catch (JAXBException ex) {
                        throw new FreemarkerUtils.TemplateProcessingException((Exception)((Object)ex));
                    }
                }
            });
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateAndSyncGradle() {
        List dependencyList;
        Object maybeDependencyList;
        if (this.myParamMap.containsKey("dependencyList") && (maybeDependencyList = this.myParamMap.get("dependencyList")) instanceof List && !(dependencyList = (List)maybeDependencyList).isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.myNeedsGradleSync && this.mySyncGradleIfNeeded && !this.myProject.isDefault() && Projects.isBuildWithGradle(this.myProject)) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    public File getTargetFile(File file) throws IOException {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myOutputRoot, file.getPath());
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        File gradleBuildFile = GradleUtil.getGradleBuildFilePath(this.myModuleRoot);
        String templateRoot = TemplateManager.getTemplateRootFolder().getPath();
        File gradleTemplate = new File(templateRoot, FileUtil.join((String[])new String[]{"gradle", "utils", "dependencies.gradle.ftl"}));
        String contents = FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, gradleTemplate, null);
        String destinationContents = null;
        if (gradleBuildFile.exists()) {
            destinationContents = TemplateUtils.readTextFile(gradleBuildFile);
        }
        if (destinationContents == null) {
            destinationContents = "";
        }
        String compileSdkVersion = (String)this.myParamMap.get("buildApiString");
        String result = GradleFileMerger.mergeGradleFiles(contents, destinationContents, this.myProject, compileSdkVersion);
        TemplateUtils.writeFile(this, result, gradleBuildFile);
        this.myNeedsGradleSync = true;
    }

    private void copyDirectory(final VirtualFile src, final VirtualFile dest) throws IOException {
        final File destinationFile = VfsUtilCore.virtualToIoFile((VirtualFile)dest);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(VirtualFile file) {
                try {
                    return RecipeContext.this.copyFile(file, src, destinationFile, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private String format(String contents, File to) {
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(to.getName());
        PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(to.getName(), type, (CharSequence)StringUtil.convertLineSeparators((String)contents));
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)file);
        return file.getText();
    }

    private void copyTemplateResource(File from, File to) throws IOException {
        from = this.myLoader.getSourceFile(from);
        to = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)from, (boolean)true);
        assert (sourceFile != null) : from;
        sourceFile.refresh(false, false);
        File destPath = from.isDirectory() ? to : to.getParentFile();
        VirtualFile destFolder = TemplateUtils.checkedCreateDirectoryIfMissing(destPath);
        if (from.isDirectory()) {
            this.copyDirectory(sourceFile, destFolder);
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                TemplateUtils.writeFile(this, document.getText(), to);
            } else {
                VfsUtilCore.copyFile((Object)this, (VirtualFile)sourceFile, (VirtualFile)destFolder, (String)to.getName());
            }
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile, VirtualFile dest) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            LOG.error(file.getPath() + " is not a child of " + src, (Throwable)new Exception());
            return false;
        }
        if (file.isDirectory()) {
            TemplateUtils.checkedCreateDirectoryIfMissing(new File(destinationFile, relativePath));
        } else {
            File target;
            VirtualFile targetDir = dest;
            if (relativePath.indexOf(File.separatorChar) > 0) {
                String directories = relativePath.substring(0, relativePath.lastIndexOf(File.separatorChar));
                File newParent = new File(destinationFile, directories);
                targetDir = TemplateUtils.checkedCreateDirectoryIfMissing(newParent);
            }
            if ((target = new File(destinationFile, relativePath)).exists()) {
                LOG.warn("Target file already exists, skipping the copy of: " + target.getPath());
            } else {
                VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)targetDir);
            }
        }
        return true;
    }
}

