/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.updater.SdkUpdaterNoWindow;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ComponentInstaller {
    private final Multimap<PkgType, RemotePkgInfo> myRemotePackages;
    private final boolean myInstallUpdates;

    public ComponentInstaller(Multimap<PkgType, RemotePkgInfo> remotePackages, boolean installUpdates) {
        this.myRemotePackages = remotePackages;
        this.myInstallUpdates = installUpdates;
    }

    private static Set<String> getPackageIds(Iterable<LocalPkgInfo> localPackages) {
        HashSet toUpdate = Sets.newHashSet();
        for (LocalPkgInfo localPkgInfo : localPackages) {
            toUpdate.add(localPkgInfo.getDesc().getBaseInstallId());
        }
        return toUpdate;
    }

    private static List<LocalPkgInfo> getInstalledPackages(SdkManager manager, Set<String> toInstall) {
        LocalSdk localSdk = manager.getLocalSdk();
        LocalPkgInfo[] installed = localSdk.getPkgsInfos(EnumSet.allOf(PkgType.class));
        ArrayList toCheckForUpdate = Lists.newArrayListWithCapacity((int)installed.length);
        for (LocalPkgInfo info : installed) {
            if (!toInstall.contains(info.getDesc().getBaseInstallId())) continue;
            toCheckForUpdate.add(info);
        }
        return toCheckForUpdate;
    }

    private Iterable<LocalPkgInfo> getOldPackages(Collection<LocalPkgInfo> installed) {
        if (this.myRemotePackages != null) {
            LocalPkgInfo[] packagesArray = (LocalPkgInfo[])ArrayUtil.toObjectArray(installed, LocalPkgInfo.class);
            SdkPackages packages = new SdkPackages(packagesArray, this.myRemotePackages);
            ArrayList result = Lists.newArrayList();
            for (UpdatablePkgInfo update : packages.getUpdatedPkgs()) {
                if (!update.hasRemote(false)) continue;
                result.add(update.getLocalInfo());
            }
            return result;
        }
        return installed;
    }

    private Set<String> getRequiredPackages(Iterable<? extends InstallableComponent> components) {
        HashSet packages = Sets.newHashSet();
        for (InstallableComponent installableComponent : components) {
            for (IPkgDesc pkg : installableComponent.getRequiredSdkPackages(this.myRemotePackages)) {
                if (pkg == null) continue;
                packages.add(pkg.getInstallId());
            }
        }
        return packages;
    }

    public ArrayList<String> getPackagesToInstall(SdkManager manager, Iterable<? extends InstallableComponent> components, boolean defaultUpdateAvailable) {
        Set<String> toInstall = this.getRequiredPackages(components);
        if (manager == null) {
            return Lists.newArrayList(toInstall);
        }
        List<LocalPkgInfo> installed = ComponentInstaller.getInstalledPackages(manager, toInstall);
        if (!installed.isEmpty()) {
            toInstall.removeAll(ComponentInstaller.getPackageIds(installed));
            if (this.myInstallUpdates && (this.myRemotePackages != null || defaultUpdateAvailable)) {
                toInstall.addAll(ComponentInstaller.getPackageIds(this.getOldPackages(installed)));
            }
        }
        return Lists.newArrayList(toInstall);
    }

    public Collection<RemotePkgInfo> getPackagesToInstallInfos(String sdkPath, Iterable<? extends InstallableComponent> components) {
        SdkManager sdkManager;
        if (!StringUtil.isEmptyOrSpaces((String)sdkPath) && this.myRemotePackages != null && (sdkManager = SdkManager.createManager((String)sdkPath, (ILogger)new NullLogger())) != null) {
            ImmutableSet packagesToInstall = ImmutableSet.copyOf(this.getPackagesToInstall(sdkManager, components, true));
            HashSet remotePackages = Sets.newHashSetWithExpectedSize((int)packagesToInstall.size());
            for (RemotePkgInfo remotePkgInfo : this.myRemotePackages.values()) {
                if (!packagesToInstall.contains(remotePkgInfo.getPkgDesc().getInstallId())) continue;
                remotePackages.add(remotePkgInfo);
            }
            return remotePackages;
        }
        return ImmutableSet.of();
    }

    public void installPackages(SdkManager manager, ArrayList<String> packages, ILogger logger) throws WizardException {
        SdkUpdaterNoWindow updater = new SdkUpdaterNoWindow(manager.getLocation(), manager, logger, false, null, null);
        updater.updateAll(packages, true, false, null, false);
    }
}

