/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public final class DownloadOperation
extends InstallOperation<File, File> {
    private final String myUrl;

    public DownloadOperation(InstallContext context, String url, double progressShare) {
        super(context, progressShare);
        this.myUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(String url, File destination, ProgressIndicator indicator) throws IOException {
        indicator.setText(String.format("Downloading %s", destination.getName()));
        HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection(url);
        int contentLength = connection.getContentLength();
        if (contentLength <= 0) {
            indicator.setIndeterminate(true);
        }
        InputStream readStream = null;
        OutputStream stream = null;
        try {
            readStream = connection.getInputStream();
            stream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[0x200000];
            int totalRead = 0;
            long startTime = System.currentTimeMillis();
            int read = readStream.read(buffer);
            while (read > 0) {
                stream.write(buffer, 0, read);
                long duration = System.currentTimeMillis() - startTime;
                long downloadRate = duration == 0L ? 0L : (long)(totalRead += read) / duration;
                String message = String.format("Downloading %1$s (%2$s/s)", destination.getName(), WelcomeUIUtils.getSizeLabel(downloadRate * 1000L));
                indicator.setText(message);
                if (contentLength > 0) {
                    indicator.setFraction((double)totalRead / (double)contentLength);
                }
                indicator.checkCanceled();
                read = readStream.read(buffer);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (readStream != null) {
                readStream.close();
            }
        }
    }

    private static String getFileName(String urlString) {
        try {
            if (URLUtil.containsScheme((String)urlString)) {
                URL url = new URL(urlString);
                return PathUtil.getFileName((String)url.getPath());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return PathUtil.getFileName((String)urlString);
    }

    @Override
    protected File perform(ProgressIndicator indicator, File arg) throws WizardException, InstallationCancelledException {
        File file = new File(this.myContext.getTempDirectory(), DownloadOperation.getFileName(this.myUrl));
        this.myContext.print(String.format("Downloading %1$s from %2$s\n", file.getName(), this.myUrl), ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.start();
        try {
            while (!this.attemptDownload(file, indicator)) {
            }
            return file;
        }
        catch (ProcessCanceledException e) {
            throw new InstallationCancelledException();
        }
    }

    private boolean attemptDownload(File file, ProgressIndicator indicator) throws WizardException {
        try {
            DownloadOperation.download(this.myUrl, file, indicator);
            return true;
        }
        catch (UnknownHostException e) {
            this.prompt(String.format("Unknown host: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
            this.prompt(details, e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
            this.prompt(details, e);
        }
        return false;
    }

    private void prompt(String details, Exception e) throws WizardException {
        this.promptToRetry(details + "\n\nPlease check your Internet connection and retry.", details, e);
    }

    @Override
    public void cleanup(File result) {
        if (result.isFile() && FileUtil.isAncestor((File)result, (File)this.myContext.getTempDirectory(), (boolean)false)) {
            FileUtil.delete((File)result);
        }
    }
}

