/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.SdkManager;
import com.android.tools.idea.npw.ImportUIUtil;
import com.android.tools.idea.sdk.LogWrapper;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.utils.ILogger;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class InstallComponentsOperation
extends InstallOperation<File, File> {
    private final Logger LOG = Logger.getInstance(this.getClass());
    private final ComponentInstaller myComponentInstaller;
    private Collection<? extends InstallableComponent> myComponents;

    public InstallComponentsOperation(InstallContext context, Collection<? extends InstallableComponent> components, ComponentInstaller componentInstaller, double progressRatio) {
        super(context, progressRatio);
        this.myComponentInstaller = componentInstaller;
        this.myComponents = components;
    }

    private static String getRetryMessage(Collection<String> packages) {
        if (!packages.isEmpty()) {
            return ImportUIUtil.formatElementListString(packages, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }
        return null;
    }

    @Override
    protected File perform(ProgressIndicator indicator, File sdkLocation) throws WizardException {
        SdkManager manager = SdkManager.createManager((String)sdkLocation.getAbsolutePath(), (ILogger)new LogWrapper(this.LOG));
        if (manager != null) {
            indicator.setText("Checking for updated SDK components");
            ArrayList<String> packages = this.myComponentInstaller.getPackagesToInstall(manager, this.myComponents, true);
            while (!packages.isEmpty()) {
                SdkManagerProgressIndicatorIntegration logger = new SdkManagerProgressIndicatorIntegration(indicator, this.myContext, packages.size());
                this.myComponentInstaller.installPackages(manager, packages, (ILogger)logger);
                manager.reloadSdk((ILogger)new LogWrapper(this.LOG));
                packages = this.myComponentInstaller.getPackagesToInstall(manager, this.myComponents, false);
                String message = InstallComponentsOperation.getRetryMessage(packages);
                if (message == null) continue;
                this.promptToRetry(message, logger.getErrors(), null);
            }
        } else {
            throw new WizardException("Corrupt SDK installation");
        }
        this.myContext.print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        return sdkLocation;
    }

    @Override
    public void cleanup(File result) {
    }
}

