/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;

public class Platform
extends InstallableComponent {
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    public Platform(ScopedStateStore store, String name, long size, String description, AndroidVersion version, boolean isDefaultPlatform) {
        super(store, name, size, description);
        this.myVersion = version;
        this.myIsDefaultPlatform = isDefaultPlatform;
    }

    private static Platform getLatestPlatform(ScopedStateStore store, Multimap<PkgType, RemotePkgInfo> remotePackages, boolean preview) {
        RemotePkgInfo latest = InstallComponentsPath.findLatestPlatform(remotePackages, preview);
        if (latest != null) {
            AndroidVersion version = latest.getPkgDesc().getAndroidVersion();
            String versionName = SdkVersionInfo.getAndroidName((int)version.getFeatureLevel());
            String description = "Android platform libraries for targeting " + versionName + " platform";
            return new Platform(store, versionName, latest.getDownloadSize(), description, version, !version.isPreview());
        }
        return null;
    }

    private static LocalPkgInfo[] getPlatformPackages(SdkManager manager) {
        if (manager != null) {
            LocalSdk localSdk = manager.getLocalSdk();
            return localSdk.getPkgsInfos(PkgType.PKG_PLATFORM);
        }
        return new LocalPkgInfo[0];
    }

    public static ComponentTreeNode createSubtree(ScopedStateStore store, Multimap<PkgType, RemotePkgInfo> remotePackages) {
        Platform latestPlatform = Platform.getLatestPlatform(store, remotePackages, false);
        Object previewPlatform = null;
        if (previewPlatform != null) {
            if (latestPlatform != null) {
                return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform, previewPlatform);
            }
            latestPlatform = previewPlatform;
        }
        if (latestPlatform != null) {
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform);
        }
        return null;
    }

    @Override
    public Collection<IPkgDesc> getRequiredSdkPackages(Multimap<PkgType, RemotePkgInfo> remotePackages) {
        MajorRevision unspecifiedRevision = new MajorRevision(FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder platform = PkgDesc.Builder.newPlatform((AndroidVersion)this.myVersion, (MajorRevision)unspecifiedRevision, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder platformSources = PkgDesc.Builder.newSource((AndroidVersion)this.myVersion, (MajorRevision)unspecifiedRevision);
        PkgDesc.Builder buildTool = PkgDesc.Builder.newBuildTool((FullRevision)Platform.findLatestCompatibleBuildTool(remotePackages, this.myVersion));
        return ImmutableList.of((Object)platform.create(), (Object)platformSources.create(), (Object)buildTool.create());
    }

    private static FullRevision findLatestCompatibleBuildTool(Multimap<PkgType, RemotePkgInfo> remotePackages, AndroidVersion version) {
        FullRevision revision = null;
        if (remotePackages != null) {
            for (RemotePkgInfo remotePkgInfo : remotePackages.get((Object)PkgType.PKG_BUILD_TOOLS)) {
                FullRevision testRevision = remotePkgInfo.getPkgDesc().getFullRevision();
                if (testRevision == null || testRevision.getMajor() != version.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
                revision = testRevision;
            }
        }
        return revision;
    }

    @Override
    public void configure(InstallContext installContext, File sdk) {
    }

    @Override
    public boolean isOptionalForSdkLocation(SdkManager manager) {
        LocalPkgInfo[] infos = Platform.getPlatformPackages(manager);
        if (infos.length == 0) {
            return !this.myIsDefaultPlatform;
        }
        for (LocalPkgInfo info : infos) {
            int apiLevel;
            IPkgDesc desc = info.getDesc();
            AndroidVersion androidVersion = desc.getAndroidVersion();
            int n = apiLevel = androidVersion == null ? 0 : androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault(SdkManager sdkManager) {
        return false;
    }
}

