/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AndroidSdk;
import com.android.tools.idea.welcome.install.AndroidVirtualDevice;
import com.android.tools.idea.welcome.install.CheckSdkOperation;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.DownloadOperation;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.Platform;
import com.android.tools.idea.welcome.install.UnpackOperation;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.welcome.wizard.SdkComponentsStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkData;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    public static final AndroidVersion LATEST_ANDROID_VERSION = new AndroidVersion(22, null);
    private static final ScopedStateStore.Key<String> KEY_SDK_INSTALL_LOCATION = ScopedStateStore.createKey("download.sdk.location", ScopedStateStore.Scope.PATH, String.class);
    private final ProgressStep myProgressStep;
    private final FirstRunWizardMode myMode;
    private final ComponentInstaller myComponentInstaller;
    private final File mySdkLocation;
    private SdkComponentsStep mySdkComponentsStep;
    private ComponentTreeNode myComponentTree;
    private final Multimap<PkgType, RemotePkgInfo> myRemotePackages;

    public InstallComponentsPath(ProgressStep progressStep, FirstRunWizardMode mode, File sdkLocation, Multimap<PkgType, RemotePkgInfo> remotePackages, boolean installUpdates) {
        this.myProgressStep = progressStep;
        this.myMode = mode;
        this.mySdkLocation = sdkLocation;
        this.myRemotePackages = remotePackages;
        this.myComponentInstaller = new ComponentInstaller(remotePackages, installUpdates);
    }

    private ComponentTreeNode createComponentTree(FirstRunWizardMode reason, ScopedStateStore stateStore, boolean createAvd) {
        ArrayList components = Lists.newArrayList();
        components.add(new AndroidSdk(stateStore));
        ComponentTreeNode platforms = Platform.createSubtree(stateStore, this.myRemotePackages);
        if (platforms != null) {
            components.add(platforms);
        }
        if (Haxm.canRun() && reason == FirstRunWizardMode.NEW_INSTALL) {
            components.add(new Haxm(stateStore, FirstRunWizard.KEY_CUSTOM_INSTALL));
        }
        if (createAvd) {
            components.add(new AndroidVirtualDevice(stateStore, this.myRemotePackages));
        }
        return new ComponentCategory("Root", "Root node that is not supposed to appear in the UI", components);
    }

    private static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }

    private static boolean hasPlatformsDir(File[] files) {
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!InstallComponentsPath.isPlatformsDir(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPlatformsDir(File file) {
        return file.isDirectory() && file.getName().equalsIgnoreCase("platforms");
    }

    private static File getSdkRoot(File expandedLocation) {
        File[] files = expandedLocation.listFiles();
        if (InstallComponentsPath.hasPlatformsDir(files)) {
            return expandedLocation;
        }
        if (files != null) {
            for (File file : files) {
                if (!InstallComponentsPath.hasPlatformsDir(file.listFiles())) continue;
                return file;
            }
        }
        return expandedLocation;
    }

    @VisibleForTesting
    static InstallOperation<File, File> downloadAndUnzipSdkSeed(InstallContext context, File destination, double progressShare) {
        double DOWNLOAD_OPERATION_PROGRESS_SHARE = progressShare * 0.8;
        double UNZIP_OPERATION_PROGRESS_SHARE = progressShare * 0.15;
        double MOVE_OPERATION_PROGRESS_SHARE = progressShare - DOWNLOAD_OPERATION_PROGRESS_SHARE - UNZIP_OPERATION_PROGRESS_SHARE;
        DownloadOperation download = new DownloadOperation(context, FirstRunWizardDefaults.getSdkDownloadUrl(), DOWNLOAD_OPERATION_PROGRESS_SHARE);
        UnpackOperation unpack = new UnpackOperation(context, UNZIP_OPERATION_PROGRESS_SHARE);
        MoveSdkOperation move = new MoveSdkOperation(context, destination, MOVE_OPERATION_PROGRESS_SHARE);
        return download.then(unpack).then(move);
    }

    private static boolean existsAndIsVisible(DynamicWizardStep step) {
        return step != null && step.isStepVisible();
    }

    private File getHandoffAndroidSdkSource() {
        File androidSrc = this.myMode.getAndroidSrc();
        if (androidSrc != null) {
            File[] files = androidSrc.listFiles();
            if (androidSrc.isDirectory() && files != null && files.length > 0) {
                return androidSrc;
            }
        }
        return null;
    }

    private InstallOperation<File, File> createInitSdkOperation(InstallContext installContext, File destination, double progressRatio) {
        File handoffSource = this.getHandoffAndroidSdkSource();
        if (handoffSource != null) {
            return new MergeOperation(handoffSource, installContext, progressRatio);
        }
        if (InstallComponentsPath.isNonEmptyDirectory(destination) && AndroidSdkData.getSdkData(destination) != null) {
            return InstallOperation.wrap(installContext, new ReturnValue(), 0.0);
        }
        return InstallComponentsPath.downloadAndUnzipSdkSeed(installContext, destination, progressRatio);
    }

    private static boolean isNonEmptyDirectory(File file) {
        String[] contents = !file.isDirectory() ? null : file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equalsIgnoreCase(".DS_Store") && !name.equalsIgnoreCase("thumbs.db") && !name.equalsIgnoreCase("desktop.ini");
            }
        });
        return contents != null && contents.length > 0;
    }

    @Override
    protected void init() {
        boolean createAvd = this.myMode.shouldCreateAvd();
        String pathString = this.mySdkLocation.getAbsolutePath();
        this.myState.put(KEY_SDK_INSTALL_LOCATION, pathString);
        this.myComponentTree = this.createComponentTree(this.myMode, this.myState, createAvd);
        this.myComponentTree.init(this.myProgressStep);
        this.mySdkComponentsStep = new SdkComponentsStep(this.myComponentTree, FirstRunWizard.KEY_CUSTOM_INSTALL, KEY_SDK_INSTALL_LOCATION, this.myMode);
        this.addStep(this.mySdkComponentsStep);
        SdkManager manager = SdkManager.createManager((String)pathString, (ILogger)new NullLogger());
        this.myComponentTree.init(this.myProgressStep);
        this.myComponentTree.updateState(manager);
        for (DynamicWizardStep step : this.myComponentTree.createSteps()) {
            this.addStep(step);
        }
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            this.addStep(new InstallSummaryStep(FirstRunWizard.KEY_CUSTOM_INSTALL, KEY_SDK_INSTALL_LOCATION, (Supplier<? extends Collection<RemotePkgInfo>>)new Supplier<Collection<RemotePkgInfo>>(){

                public Collection<RemotePkgInfo> get() {
                    return InstallComponentsPath.this.myComponentInstaller.getPackagesToInstallInfos((String)InstallComponentsPath.this.myState.get(KEY_SDK_INSTALL_LOCATION), InstallComponentsPath.this.myComponentTree.getChildrenToInstall());
                }
            }));
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        if (modified.contains(KEY_SDK_INSTALL_LOCATION)) {
            String sdkPath = this.myState.get(KEY_SDK_INSTALL_LOCATION);
            SdkManager manager = null;
            if (sdkPath != null) {
                manager = SdkManager.createManager((String)sdkPath, (ILogger)new NullLogger());
            }
            this.myComponentTree.updateState(manager);
        }
        if (modified.contains(FirstRunWizard.KEY_CUSTOM_INSTALL) || modified.contains(KEY_SDK_INSTALL_LOCATION) || this.myComponentTree.componentStateChanged(modified)) {
            this.myState.put(WizardConstants.INSTALL_REQUESTS_KEY, this.getPackageDescriptions());
        }
    }

    private List<IPkgDesc> getPackageDescriptions() {
        Collection<RemotePkgInfo> installIds = this.myComponentInstaller.getPackagesToInstallInfos(this.myState.get(KEY_SDK_INSTALL_LOCATION), this.myComponentTree.getChildrenToInstall());
        ImmutableList.Builder packages = ImmutableList.builder();
        for (RemotePkgInfo remotePackage : installIds) {
            packages.add((Object)remotePackage.getPkgDesc());
        }
        return packages.build();
    }

    @Override
    public String getPathName() {
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        double INIT_SDK_OPERATION_PROGRESS_SHARE = 0.3;
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 0.7;
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep);
        File destination = this.getDestination();
        InstallOperation<File, File> initialize = this.createInitSdkOperation(installContext, destination, 0.3);
        Collection<InstallableComponent> selectedComponents = this.myComponentTree.getChildrenToInstall();
        CheckSdkOperation checkSdk = new CheckSdkOperation(installContext);
        InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, this.myComponentInstaller, 0.7);
        SetPreference setPreference = new SetPreference(this.myMode.getInstallerTimestamp());
        try {
            initialize.then(checkSdk).then(install).then(setPreference).then(new ConfigureComponents(installContext, selectedComponents)).execute(destination);
        }
        catch (InstallationCancelledException e) {
            installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public static RemotePkgInfo findLatestPlatform(Multimap<PkgType, RemotePkgInfo> remotePackages, boolean preview) {
        ArrayList packages = Lists.newArrayList((Iterable)remotePackages.get((Object)PkgType.PKG_PLATFORM));
        Collections.sort(packages);
        Collections.reverse(packages);
        RemotePkgInfo latest = null;
        for (RemotePkgInfo pkg : packages) {
            boolean isPreview = pkg.getPkgDesc().getAndroidVersion().isPreview();
            if (preview) {
                if (!isPreview) break;
                latest = pkg;
                break;
            }
            if (isPreview) continue;
            latest = pkg;
            break;
        }
        return latest;
    }

    private File getDestination() throws WizardException {
        String destinationPath = this.myState.get(KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        return destination;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    public boolean showsStep() {
        return this.isPathVisible() && (InstallComponentsPath.existsAndIsVisible(this.mySdkComponentsStep) || this.myMode == FirstRunWizardMode.NEW_INSTALL);
    }

    private static class ConfigureComponents
    implements Function<File, File> {
        private final InstallContext myInstallContext;
        private final Collection<? extends InstallableComponent> mySelectedComponents;

        public ConfigureComponents(InstallContext installContext, Collection<? extends InstallableComponent> selectedComponents) {
            this.myInstallContext = installContext;
            this.mySelectedComponents = selectedComponents;
        }

        public File apply(File input) {
            assert (input != null);
            for (InstallableComponent installableComponent : this.mySelectedComponents) {
                installableComponent.configure(this.myInstallContext, input);
            }
            return input;
        }
    }

    private static class SetPreference
    implements Function<File, File> {
        private final String myInstallerTimestamp;

        public SetPreference(String installerTimestamp) {
            this.myInstallerTimestamp = installerTimestamp;
        }

        public File apply(final File input) {
            assert (input != null);
            final Application application = ApplicationManager.getApplication();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            IdeSdks.setAndroidSdkPath(input, null);
                            AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(SetPreference.this.myInstallerTimestamp);
                        }
                    });
                }
            }, application.getAnyModalityState());
            return input;
        }
    }

    private static class ReturnValue
    implements Function<File, File> {
        private ReturnValue() {
        }

        public File apply(File input) {
            assert (input != null);
            return input;
        }
    }

    private static class MoveSdkOperation
    extends InstallOperation<File, File> {
        private final File myDestination;

        public MoveSdkOperation(InstallContext context, File destination, double progressShare) {
            super(context, progressShare);
            this.myDestination = destination;
        }

        @Override
        protected File perform(ProgressIndicator indicator, File file) throws WizardException {
            indicator.setText("Moving downloaded SDK");
            indicator.start();
            try {
                File root = InstallComponentsPath.getSdkRoot(file);
                if (!root.renameTo(this.myDestination)) {
                    FileUtil.copyDir((File)root, (File)this.myDestination);
                    FileUtil.delete((File)root);
                }
                File file2 = this.myDestination;
                return file2;
            }
            catch (IOException e) {
                throw new WizardException("Unable to move Android SDK", e);
            }
            finally {
                indicator.setFraction(1.0);
                indicator.stop();
            }
        }

        @Override
        public void cleanup(File result) {
        }
    }

    private static class MergeOperation
    extends InstallOperation<File, File> {
        private final File myRepo;
        private final InstallContext myContext;
        private boolean myRepoWasMerged = false;

        public MergeOperation(File repo, InstallContext context, double progressRatio) {
            super(context, progressRatio);
            this.myRepo = repo;
            this.myContext = context;
        }

        @Override
        protected File perform(ProgressIndicator indicator, File destination) throws WizardException {
            indicator.setText("Installing Android SDK");
            try {
                FileUtil.ensureExists((File)destination);
                if (!FileUtil.filesEqual((File)destination.getCanonicalFile(), (File)this.myRepo.getCanonicalFile())) {
                    SdkMerger.mergeSdks(this.myRepo, destination, indicator);
                    this.myRepoWasMerged = true;
                }
                this.myContext.print(String.format("Android SDK was installed to %1$s\n", destination), ConsoleViewContentType.SYSTEM_OUTPUT);
                File file = destination;
                return file;
            }
            catch (IOException e) {
                throw new WizardException(e.getMessage(), e);
            }
            finally {
                indicator.stop();
            }
        }

        @Override
        public void cleanup(File result) {
            if (this.myRepoWasMerged && this.myRepo.exists()) {
                FileUtil.delete((File)this.myRepo);
            }
        }
    }
}

