/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.wizard.FirstRunWizardHost;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import javax.swing.JFrame;

public final class WelcomeScreenWindowListener {
    public static WindowListener install(JFrame frame, FirstRunWizardHost host) {
        WindowListener ideaListener = WelcomeScreenWindowListener.removeCloseListener(frame);
        DirectListener ourListener = ideaListener != null ? new DelegatingListener(host, ideaListener) : new DirectListener(host);
        frame.addWindowListener(ourListener);
        return ourListener;
    }

    private static WindowListener removeCloseListener(JFrame frame) {
        WindowListener[] listeners;
        for (WindowListener listener : listeners = (WindowListener[])frame.getListeners(WindowListener.class)) {
            if (!listener.getClass().getName().startsWith(WelcomeFrame.class.getName())) continue;
            frame.removeWindowListener(listener);
            return listener;
        }
        return null;
    }

    private static boolean handleClose(FirstRunWizardHost host) {
        if (host != null && host.isActive()) {
            host.cancel();
            return true;
        }
        return false;
    }

    private static class DirectListener
    extends WindowAdapter {
        private final WeakReference<FirstRunWizardHost> myHostReference;

        public DirectListener(FirstRunWizardHost host) {
            this.myHostReference = new WeakReference<FirstRunWizardHost>(host);
        }

        protected final FirstRunWizardHost getHost() {
            return (FirstRunWizardHost)this.myHostReference.get();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (!WelcomeScreenWindowListener.handleClose(this.getHost())) {
                e.getWindow().removeWindowListener(this);
            }
        }
    }

    private static class DelegatingListener
    extends DirectListener {
        private final WindowListener myIdeaListener;

        public DelegatingListener(FirstRunWizardHost host, WindowListener ideaListener) {
            super(host);
            this.myIdeaListener = ideaListener;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.myIdeaListener.windowOpened(e);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.myIdeaListener.windowClosed(e);
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.myIdeaListener.windowIconified(e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (!WelcomeScreenWindowListener.handleClose(this.getHost())) {
                Window window = e.getWindow();
                window.removeWindowListener(this);
                window.addWindowListener(this.myIdeaListener);
                this.myIdeaListener.windowClosing(e);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.myIdeaListener.windowDeiconified(e);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.myIdeaListener.windowActivated(e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.myIdeaListener.windowDeactivated(e);
        }
    }
}

