/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class DynamicWizardStepWithHeaderAndDescription
extends DynamicWizardStepWithDescription
implements Disposable {
    protected static final ScopedStateStore.Key<String> KEY_TITLE = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".title", ScopedStateStore.Scope.STEP, String.class);
    protected static final ScopedStateStore.Key<String> KEY_MESSAGE = ScopedStateStore.createKey(DynamicWizardStepWithHeaderAndDescription.class + ".message", ScopedStateStore.Scope.STEP, String.class);
    private final String myTitle;
    private final String myMessage;
    private JBLabel myTitleLabel;
    private JBLabel myMessageLabel;
    private JPanel myHeaderPane;

    public DynamicWizardStepWithHeaderAndDescription(String title, String message, Disposable parentDisposable) {
        super(parentDisposable);
        this.myTitle = title;
        this.myMessage = message;
        this.$$$setupUI$$$();
        int fontHeight = this.myMessageLabel.getFont().getSize();
        this.myTitleLabel.setBorder(BorderFactory.createEmptyBorder(fontHeight, 0, fontHeight, 0));
        Insets topSegmentInsets = new Insets(18, WizardConstants.STUDIO_WIZARD_INSET_SIZE, 0, WizardConstants.STUDIO_WIZARD_INSET_SIZE);
        this.myHeaderPane.setBorder(new EmptyBorder(topSegmentInsets));
        Font font = this.myTitleLabel.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        font = new Font(font.getName(), font.getStyle() | 1, font.getSize() + 4);
        this.myTitleLabel.setFont(font);
    }

    protected String getTitle() {
        return this.myTitle;
    }

    @Override
    protected JPanel createStepBody() {
        JPanel body = super.createStepBody();
        body.add((Component)this.myHeaderPane, "North");
        return body;
    }

    @Override
    public void init() {
        super.init();
        this.myState.put(KEY_TITLE, this.myTitle);
        this.myState.put(KEY_MESSAGE, this.myMessage);
        this.register(KEY_TITLE, this.myTitleLabel, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

            @Override
            public void setValue(String newValue, JBLabel component) {
                component.setText(newValue);
            }
        });
        this.register(KEY_MESSAGE, this.myMessageLabel, new ScopedDataBinder.ComponentBinding<String, JLabel>(){

            @Override
            public void setValue(String newValue, JLabel component) {
                component.setVisible(!StringUtil.isEmpty((String)newValue));
                component.setText(DynamicWizardStepWithHeaderAndDescription.this.toHtml(newValue));
            }
        });
    }

    protected WizardStepHeaderSettings getStepHeader() {
        return WizardStepHeaderSettings.createProductHeader(this.myTitle);
    }

    @Override
    protected String getStepTitle() {
        return this.getStepHeader().title;
    }

    @Override
    protected String getStepDescription() {
        return this.getStepHeader().description;
    }

    @Override
    protected JBColor getHeaderColor() {
        JBColor color = this.getStepHeader().color;
        return color == null ? super.getHeaderColor() : color;
    }

    @Override
    protected Icon getStepIcon() {
        return this.getStepHeader().stepIcon;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myHeaderPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Wizard Step Title");
        jBLabel2.setHorizontalAlignment(10);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myMessageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Wizard step description message");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 3, 1, 1, 0, 1, 6, new Dimension(-1, 100), new Dimension(-1, 100), new Dimension(-1, 100)));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myHeaderPane;
    }

    public static final class WizardStepHeaderSettings {
        public static final String PRODUCT_DESCRIPTION = "Android Studio";
        public final String title;
        public final String description;
        public final Icon stepIcon;
        public final JBColor color;

        private WizardStepHeaderSettings(String title, String description, Icon stepIcon, JBColor color) {
            this.title = title;
            this.description = description;
            this.stepIcon = stepIcon;
            this.color = color;
        }

        public static WizardStepHeaderSettings createCustomColorHeader(JBColor color, String title) {
            return new WizardStepHeaderSettings(title, PRODUCT_DESCRIPTION, null, color);
        }

        public static WizardStepHeaderSettings createProductHeader(String title) {
            return new WizardStepHeaderSettings(title, PRODUCT_DESCRIPTION, null, null);
        }

        public static WizardStepHeaderSettings createTitleOnlyHeader(String title) {
            return new WizardStepHeaderSettings(title, null, null, null);
        }

        public static WizardStepHeaderSettings createTitleAndDescriptionHeader(String title, String description) {
            return new WizardStepHeaderSettings(title, description, null, null);
        }
    }
}

