/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.api.IImageFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Graphics2DDelegate;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;

public class FakeImageFactory
implements IImageFactory {
    private static final Logger LOG = Logger.getInstance(FakeImageFactory.class);
    private static final Graphics2D NOP_GRAPHICS2D = new BufferedImage(1, 1, 2).createGraphics();
    private Graphics myGraphics = NOP_GRAPHICS2D;
    private int myRequestedHeight;
    private int myRequestedWidth;

    public void setGraphics(Graphics graphics) {
        this.myGraphics = graphics != null ? graphics : NOP_GRAPHICS2D;
    }

    public int getRequestedHeight() {
        return this.myRequestedHeight;
    }

    public int getRequestedWidth() {
        return this.myRequestedWidth;
    }

    public BufferedImage getImage(final int w, final int h) {
        return new BufferedImage(1, 1, 2){

            @Override
            public Graphics2D createGraphics() {
                FakeImageFactory.this.myRequestedHeight = h;
                FakeImageFactory.this.myRequestedWidth = w;
                final Shape originalClip = FakeImageFactory.this.myGraphics.getClip();
                final AffineTransform originalTx = ((Graphics2D)FakeImageFactory.this.myGraphics).getTransform();
                AffineTransform inverse = null;
                if (originalTx != null) {
                    try {
                        inverse = originalTx.createInverse();
                    }
                    catch (NoninvertibleTransformException e) {
                        LOG.error((Throwable)e);
                    }
                }
                final AffineTransform originalTxInverse = inverse;
                return new Graphics2DDelegate((Graphics2D)FakeImageFactory.this.myGraphics.create()){

                    private Shape intersect(Shape s1, Shape s2) {
                        if (s1 == null || s2 == null) {
                            return s1 == null ? s2 : s1;
                        }
                        Area a1 = new Area(s1);
                        Area a2 = new Area(s2);
                        a1.intersect(a2);
                        return a1;
                    }

                    public void clip(Shape s) {
                        if (s == null) {
                            this.setClip(null);
                            return;
                        }
                        super.clip(s);
                    }

                    public void setClip(Shape sh) {
                        try {
                            super.setClip(this.intersect(this.getTransform().createInverse().createTransformedShape(originalClip), sh));
                        }
                        catch (NoninvertibleTransformException e) {
                            LOG.error((Throwable)e);
                        }
                    }

                    public void setTransform(AffineTransform Tx) {
                        if (originalTx != null) {
                            AffineTransform transform = (AffineTransform)originalTx.clone();
                            transform.concatenate(Tx);
                            super.setTransform(transform);
                        } else {
                            super.setTransform(Tx);
                        }
                    }

                    public AffineTransform getTransform() {
                        AffineTransform currentTransform = super.getTransform();
                        if (originalTxInverse != null) {
                            currentTransform.concatenate(originalTxInverse);
                        }
                        return currentTransform;
                    }
                };
            }

            @Override
            public int getWidth() {
                return w;
            }

            @Override
            public int getHeight() {
                return h;
            }
        };
    }
}

