/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.AssetRepositoryImpl;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.swing.layoutlib.FakeImageFactory;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.uipreview.RenderingException;

public class GraphicsLayoutRenderer {
    private static final Logger LOG = Logger.getInstance(GraphicsLayoutRenderer.class);
    private static final int MIN_LAYOUTLIB_API_VERSION = 15;
    private final FakeImageFactory myImageFactory;
    private final DynamicHardwareConfig myHardwareConfig;
    private final Object myCredential;
    private final RenderSecurityManager mySecurityManager;
    private boolean myInvalidate;
    private final List<ResourceValue> myResourceLookupChain;
    private ReentrantReadWriteLock myRenderSessionLock = new ReentrantReadWriteLock();
    private RenderSession myRenderSession;
    private double myScale = 1.0;

    private GraphicsLayoutRenderer(LayoutLibrary layoutLib, SessionParams sessionParams, RenderSecurityManager securityManager, DynamicHardwareConfig hardwareConfig, List<ResourceValue> resourceLookupChain, Object credential) {
        this.mySecurityManager = securityManager;
        this.myHardwareConfig = hardwareConfig;
        this.myImageFactory = new FakeImageFactory();
        this.myResourceLookupChain = resourceLookupChain;
        this.myCredential = credential;
        sessionParams.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)Boolean.TRUE);
        sessionParams.setImageFactory((IImageFactory)this.myImageFactory);
        this.myRenderSession = GraphicsLayoutRenderer.initRenderSession(layoutLib, sessionParams, this.mySecurityManager, this.myCredential);
    }

    protected static GraphicsLayoutRenderer create(AndroidFacet facet, AndroidPlatform platform, IAndroidTarget target, Project project, Configuration configuration, ILayoutPullParser parser, Color backgroundColor, SessionParams.RenderingMode renderingMode) throws InitializationException {
        LayoutLibrary layoutLib;
        Module module = facet.getModule();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        try {
            IAndroidTarget latestTarget = configuration.getConfigurationManager().getHighestApiTarget();
            layoutLib = platform.getSdkData().getTargetData(latestTarget).getLayoutLibrary(project);
            if (layoutLib == null) {
                throw new InitializationException("getLayoutLibrary() returned null");
            }
        }
        catch (RenderingException e) {
            throw new InitializationException(e);
        }
        catch (IOException e) {
            throw new InitializationException(e);
        }
        if (layoutLib.getApiLevel() < 15) {
            throw new UnsupportedLayoutlibException("GraphicsLayoutRenderer requires at least layoutlib version 15");
        }
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        Object credential = new Object();
        RenderLogger logger = new RenderLogger("theme_editor", module, credential);
        final ActionBarCallback actionBarCallback = new ActionBarCallback();
        LayoutlibCallbackImpl layoutlibCallback = new LayoutlibCallbackImpl(null, layoutLib, appResources, module, facet, logger, credential, null){

            @Override
            public ActionBarCallback getActionBarCallback() {
                return actionBarCallback;
            }
        };
        layoutlibCallback.loadAndParseRClass();
        Device device = configuration.getDevice();
        assert (device != null);
        HardwareConfigHelper hardwareConfigHelper = new HardwareConfigHelper(device);
        DynamicHardwareConfig hardwareConfig = new DynamicHardwareConfig(hardwareConfigHelper.getConfig());
        ArrayList<ResourceValue> resourceLookupChain = new ArrayList<ResourceValue>();
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        assert (resourceResolver != null);
        ResourceResolver recordingResourceResolver = resourceResolver.createRecorder(resourceLookupChain);
        SessionParams params = new SessionParams(parser, renderingMode, (Object)module, (HardwareConfig)hardwareConfig, (RenderResources)recordingResourceResolver, (LayoutlibCallback)layoutlibCallback, moduleInfo.getMinSdkVersion().getApiLevel(), moduleInfo.getTargetSdkVersion().getApiLevel(), (LayoutLog)logger, target instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)new AssetRepositoryImpl(facet));
        params.setAppLabel("");
        if (backgroundColor != null) {
            params.setOverrideBgColor(backgroundColor.getRGB());
        }
        RenderSecurityManager mySecurityManager = RenderSecurityManagerFactory.create(module, platform);
        return new GraphicsLayoutRenderer(layoutLib, params, mySecurityManager, hardwareConfig, resourceLookupChain, credential);
    }

    public static GraphicsLayoutRenderer create(Configuration configuration, ILayoutPullParser parser, Color backgroundColor, boolean hasHorizontalScroll, boolean hasVerticalScroll) throws InitializationException {
        AndroidFacet facet = AndroidFacet.getInstance(configuration.getModule());
        if (facet == null) {
            throw new InitializationException("Unable to get AndroidFacet");
        }
        Module module = facet.getModule();
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            throw new InitializationException("Unable to get IAndroidTarget");
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            throw new InitializationException("Unable to get AndroidPlatform");
        }
        SessionParams.RenderingMode renderingMode = hasVerticalScroll && hasHorizontalScroll ? SessionParams.RenderingMode.FULL_EXPAND : (hasVerticalScroll ? SessionParams.RenderingMode.V_SCROLL : (hasHorizontalScroll ? SessionParams.RenderingMode.H_SCROLL : SessionParams.RenderingMode.NORMAL));
        return GraphicsLayoutRenderer.create(facet, platform, target, module.getProject(), configuration, parser, backgroundColor, renderingMode);
    }

    private Dimension modelToView(int width, int height) {
        return new Dimension((int)((double)width * this.myScale), (int)((double)height * this.myScale));
    }

    private Dimension viewToModel(int width, int height) {
        return new Dimension((int)((double)width / this.myScale), (int)((double)height / this.myScale));
    }

    private Point viewToModel(Point p) {
        return new Point((int)((double)p.x / this.myScale), (int)((double)p.y / this.myScale));
    }

    public void setScale(double scale) {
        this.myScale = scale;
        this.setSize(new Dimension(this.myHardwareConfig.getScreenWidth(), this.myHardwareConfig.getScreenHeight()));
    }

    public void setSize(int width, int height) {
        Dimension dimen = this.viewToModel(width, height);
        this.myHardwareConfig.setScreenSize(Math.max(dimen.width, 1), Math.max(dimen.height, 1));
        this.myInvalidate = true;
    }

    public void setSize(Dimension dimen) {
        this.setSize(dimen.width, dimen.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(Graphics2D graphics) {
        this.myRenderSessionLock.readLock().lock();
        try {
            if (!SystemInfo.isMac) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.myImageFactory.setGraphics(graphics);
            AffineTransform oldTransform = graphics.getTransform();
            if (this.myScale != 1.0) {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                AffineTransform scaleTransform = new AffineTransform(oldTransform);
                scaleTransform.scale(this.myScale, this.myScale);
                graphics.setTransform(scaleTransform);
            }
            Result result = null;
            try {
                result = RenderService.runRenderAction(new Callable<Result>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Result call() {
                        GraphicsLayoutRenderer.this.mySecurityManager.setActive(true, GraphicsLayoutRenderer.this.myCredential);
                        try {
                            Result result = GraphicsLayoutRenderer.this.myRenderSession.render(250L, GraphicsLayoutRenderer.this.myInvalidate);
                            return result;
                        }
                        finally {
                            GraphicsLayoutRenderer.this.mySecurityManager.setActive(false, GraphicsLayoutRenderer.this.myCredential);
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("Exception running render action", (Throwable)e);
            }
            if (this.myScale != 1.0) {
                graphics.setTransform(oldTransform);
            }
            if (result != null && result.getStatus() != Result.Status.SUCCESS) {
                if (result.getException() != null) {
                    LOG.warn(result.getException());
                } else {
                    LOG.warn("Render error (no exception). Status=" + result.getStatus().name());
                }
                boolean bl = false;
                return bl;
            }
            this.myInvalidate = false;
            boolean bl = true;
            return bl;
        }
        finally {
            this.myRenderSessionLock.readLock().unlock();
        }
    }

    private static RenderSession initRenderSession(final LayoutLibrary layoutLibrary, final SessionParams sessionParams, final RenderSecurityManager securityManager, final Object credential) {
        try {
            RenderSession session = RenderService.runRenderAction(new Callable<RenderSession>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public RenderSession call() {
                    securityManager.setActive(true, credential);
                    try {
                        RenderSession renderSession = (RenderSession)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderSession>(){

                            public RenderSession compute() {
                                return layoutLibrary.createSession(sessionParams);
                            }
                        });
                        return renderSession;
                    }
                    finally {
                        securityManager.setActive(false, credential);
                    }
                }
            });
            if (session == null) {
                LOG.warn("initRenderSession failed (returned null)");
                return null;
            }
            Result result = session.getResult();
            if (result != null && result.getStatus() != Result.Status.SUCCESS) {
                if (result.getException() != null) {
                    LOG.warn(result.getException());
                } else {
                    LOG.warn("Render error (no exception). Status=" + result.getStatus().name());
                }
            }
            return session;
        }
        catch (Exception e) {
            LOG.warn("initRenderSession failed", (Throwable)e);
            return null;
        }
    }

    public Set<String> getUsedAttrs() {
        HashSet<String> usedAttrs = new HashSet<String>();
        for (ResourceValue value : this.myResourceLookupChain) {
            if (!(value instanceof ItemResourceValue) || value.getName() == null) continue;
            ItemResourceValue itemValue = (ItemResourceValue)value;
            usedAttrs.add((itemValue.isFrameworkAttr() ? "android:" : "") + itemValue.getName());
        }
        return Collections.unmodifiableSet(usedAttrs);
    }

    private static ViewInfo viewAtPoint(Point parentPosition, ViewInfo view, Point p) {
        int y;
        ViewInfo bounds = RenderService.getSafeBounds(view);
        int x = parentPosition.x + bounds.getLeft();
        Rectangle rect = new Rectangle(x, y = parentPosition.y + bounds.getTop(), bounds.getRight() - bounds.getLeft(), bounds.getBottom() - bounds.getTop());
        if (rect.contains(p)) {
            for (ViewInfo childView : view.getChildren()) {
                ViewInfo hitView;
                if (childView.getCookie() == null || (hitView = GraphicsLayoutRenderer.viewAtPoint(rect.getLocation(), childView, p)) == null) continue;
                return hitView;
            }
            return view;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewInfo findViewAtPoint(Point p) {
        this.myRenderSessionLock.readLock().lock();
        try {
            if (this.myRenderSession == null) {
                ViewInfo viewInfo = null;
                return viewInfo;
            }
            p = this.viewToModel(p);
            List rootViews = this.myRenderSession.getRootViews();
            if (rootViews == null) {
                ViewInfo viewInfo = null;
                return viewInfo;
            }
            Point base = new Point();
            for (ViewInfo view : rootViews) {
                ViewInfo hitView = GraphicsLayoutRenderer.viewAtPoint(base, view, p);
                if (hitView == null) continue;
                ViewInfo viewInfo = hitView;
                return viewInfo;
            }
            ViewInfo viewInfo = null;
            return viewInfo;
        }
        finally {
            this.myRenderSessionLock.readLock().unlock();
        }
    }

    public Dimension getPreferredSize() {
        return this.modelToView(this.myImageFactory.getRequestedWidth(), this.myImageFactory.getRequestedHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myRenderSessionLock.writeLock().lock();
        try {
            if (this.myRenderSession != null) {
                this.myImageFactory.setGraphics(null);
                this.myRenderSession.dispose();
                this.myRenderSession = null;
            }
        }
        finally {
            this.myRenderSessionLock.writeLock().unlock();
        }
    }

    static class DynamicHardwareConfig
    extends HardwareConfig {
        private int myWidth;
        private int myHeight;

        public DynamicHardwareConfig(HardwareConfig delegate) {
            super(delegate.getScreenWidth(), delegate.getScreenHeight(), delegate.getDensity(), delegate.getXdpi(), delegate.getYdpi(), delegate.getScreenSize(), delegate.getOrientation(), delegate.getScreenRoundness(), delegate.hasSoftwareButtons());
            this.myWidth = delegate.getScreenWidth();
            this.myHeight = delegate.getScreenHeight();
        }

        public void setScreenSize(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }
    }
}

