/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.ui;

import com.android.tools.swing.util.GraphicsUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SwatchComponent
extends JComponent {
    private static final int PADDING = JBUI.scale((int)2);
    private static final int TEXT_PADDING = JBUI.scale((int)8);
    private static final int SWATCH_HORIZONTAL_ICONS_PADDING = JBUI.scale((int)2);
    private static final int ARC_SIZE = 10;
    private static final Color DEFAULT_BORDER_COLOR = Gray._170;
    private static final Color WARNING_BORDER_COLOR = JBColor.ORANGE;
    private String myText = "";
    private List<SwatchIcon> myIconList = Collections.emptyList();
    private short myMaxIcons;
    private boolean myHasOverflowIcons;
    private Color myBorderColor;

    public SwatchComponent(short maxIcons) {
        this.myMaxIcons = maxIcons;
        this.setBorder(null);
        this.myBorderColor = DEFAULT_BORDER_COLOR;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SwatchComponent.this.mouseReleased(e);
            }
        });
    }

    public void setMaxIcons(short maxIcons) {
        this.myMaxIcons = maxIcons;
    }

    public void setSwatchIcons(List<? extends SwatchIcon> icons) {
        this.myIconList = ImmutableList.copyOf(icons);
    }

    public void setWarningBorder(boolean isWarning) {
        this.myBorderColor = isWarning ? WARNING_BORDER_COLOR : DEFAULT_BORDER_COLOR;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int iconsToPaint;
        com.intellij.util.ui.GraphicsUtil.setupAAPainting((Graphics)graphics);
        Graphics2D g = (Graphics2D)graphics.create();
        int width = this.getWidth();
        int height = this.getHeight();
        int iconSize = this.getIconSize();
        g.setColor(this.getBackground());
        if (this.getBorder() == null) {
            g.fillRoundRect(0, 0, width - 1, height - 1, 10, 10);
            g.setColor(this.myBorderColor);
            g.drawRoundRect(0, 0, width - 1, height - 1, 10, 10);
        } else {
            g.fillRect(0, 0, width - 1, height - 1);
        }
        Shape savedClip = g.getClip();
        int xOffset = PADDING;
        int nIcons = this.myIconList.size();
        RoundRectangle2D.Double clipRectangle = new RoundRectangle2D.Double();
        if (nIcons - this.myMaxIcons >= 2) {
            this.myHasOverflowIcons = true;
            iconsToPaint = this.myMaxIcons;
        } else {
            this.myHasOverflowIcons = false;
            iconsToPaint = nIcons;
        }
        for (SwatchIcon icon : this.myIconList) {
            if (iconsToPaint == 0) {
                icon = new TextIcon("+" + (nIcons - this.myMaxIcons), this.getFont());
            } else if (iconsToPaint < 0) break;
            ((RoundRectangle2D)clipRectangle).setRoundRect(xOffset, PADDING, iconSize, iconSize, 10.0, 10.0);
            g.clip(clipRectangle);
            icon.paint(this, g, xOffset, PADDING, iconSize, iconSize);
            g.setColor((Color)Gray._239);
            g.setClip(savedClip);
            g.drawRoundRect(xOffset, PADDING, iconSize, iconSize, 10, 10);
            xOffset += iconSize + SWATCH_HORIZONTAL_ICONS_PADDING;
            --iconsToPaint;
        }
        Rectangle textRectangle = new Rectangle(xOffset += SWATCH_HORIZONTAL_ICONS_PADDING * 2, 0, width - xOffset, height);
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        GraphicsUtil.drawCenteredString(g, textRectangle, this.myText, false, true);
        g.dispose();
    }

    @Override
    public Dimension getMinimumSize() {
        if (!this.isPreferredSizeSet()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            return new Dimension(0, fm.getHeight() + 2 * PADDING + 2 * TEXT_PADDING);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return this.getMinimumSize();
        }
        return super.getPreferredSize();
    }

    private int getIconSize() {
        return this.getHeight() - 2 * PADDING - 1;
    }

    public static List<SwatchIcon> colorListOf(List<Color> colors) {
        ImmutableList.Builder colorIcons = ImmutableList.builder();
        for (Color color : colors) {
            colorIcons.add((Object)new ColorIcon(color));
        }
        return colorIcons.build();
    }

    public static List<SwatchIcon> imageListOf(List<BufferedImage> images) {
        ImmutableList.Builder iconsList = ImmutableList.builder();
        for (BufferedImage image : images) {
            iconsList.add((Object)new SquareImageIcon(new ImageIcon(image)));
        }
        return iconsList.build();
    }

    public void setText(String text) {
        this.myText = text;
    }

    public String getText() {
        return this.myText;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void mouseReleased(MouseEvent e) {
        int iconSize;
        Rectangle overflowIconRect;
        if (!SwingUtilities.isLeftMouseButton(e) || !this.contains(e.getPoint())) {
            return;
        }
        if (this.myHasOverflowIcons && (overflowIconRect = new Rectangle(this.myMaxIcons * (iconSize = this.getIconSize()), PADDING, iconSize, iconSize)).contains(e.getPoint())) {
            final short previousMaxIcons = this.myMaxIcons;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    SwatchComponent.this.removeMouseListener(this);
                    SwatchComponent.this.setMaxIcons(previousMaxIcons);
                    SwatchComponent.this.repaint();
                }
            });
            this.setMaxIcons((short)Short.MAX_VALUE);
            this.repaint();
            return;
        }
        ActionListener[] actionListeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        ActionEvent event = new ActionEvent(this, 1001, this.myText, e.getWhen(), e.getModifiers());
        for (ActionListener listener : actionListeners) {
            listener.actionPerformed(event);
        }
    }

    public static class TextIcon
    implements SwatchIcon {
        private final Font myFont;
        private final String myText;

        public TextIcon(String text, Font font) {
            this.myText = text;
            this.myFont = font;
        }

        @Override
        public void paint(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.fillRect(x, y, w, h);
            g.setColor((Color)JBColor.DARK_GRAY);
            g.setFont(this.myFont);
            GraphicsUtil.drawCenteredString(g, new Rectangle(x, y, w, h), this.myText);
        }
    }

    public static class SquareImageIcon
    implements SwatchIcon {
        private ImageIcon myImageIcon;

        public SquareImageIcon(ImageIcon imageIcon) {
            this.myImageIcon = imageIcon;
        }

        @Override
        public void paint(Component c, Graphics g, int x, int y, int w, int h) {
            Image image = this.myImageIcon.getImage();
            GraphicsUtil.paintCheckeredBackground(g, new Rectangle(x, y, w, h));
            g.drawImage(image, x, y, w, h, c);
        }
    }

    public static class ColorIcon
    implements SwatchIcon {
        private final Color myColor;

        public ColorIcon(Color color) {
            this.myColor = color;
        }

        @Override
        public void paint(Component c, Graphics g, int x, int y, int w, int h) {
            if (this.myColor.getAlpha() != 255) {
                GraphicsUtil.paintCheckeredBackground(g, new Rectangle(x, y, w, h));
            }
            g.setColor(this.myColor);
            g.fillRect(x, y, w, h);
        }
    }

    public static interface SwatchIcon {
        public void paint(Component var1, Graphics var2, int var3, int var4, int var5, int var6);
    }
}

