/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.EmptyXmlTag;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.refactoring.AndroidRefactoringContextProvider;

public class AndroidDesignerRefactoringContextProvider
implements AndroidRefactoringContextProvider {
    @Override
    public XmlTag[] getComponentTags(DataContext dataContext) {
        EditableArea area = (EditableArea)EditableArea.DATA_KEY.getData(dataContext);
        if (area == null) {
            return XmlTag.EMPTY;
        }
        List selection = area.getSelection();
        if (selection.size() == 0) {
            return XmlTag.EMPTY;
        }
        ArrayList<XmlTag> tags = new ArrayList<XmlTag>(selection.size());
        for (RadComponent component : selection) {
            if (!(component instanceof RadViewComponent)) {
                return XmlTag.EMPTY;
            }
            XmlTag tag = ((RadViewComponent)component).getTag();
            if (tag == null || tag.equals(EmptyXmlTag.INSTANCE)) {
                return XmlTag.EMPTY;
            }
            tags.add(tag);
        }
        return tags.toArray(new XmlTag[tags.size()]);
    }
}

