/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface;

import com.android.sdklib.IAndroidTarget;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.model.MetaManager;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.module.Module;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.android.uipreview.ModuleClassLoader;

public class AndroidPasteFactory
implements ComponentPasteFactory {
    public static final String KEY = "PASTE_DATA";
    private final Module myModule;
    private final IAndroidTarget myTarget;
    private final MetaManager myMetaManager;
    private final String myXmlComponents;
    private ClassLoader myClassLoader;

    public AndroidPasteFactory(Module module, IAndroidTarget target, String xmlComponents) {
        this.myModule = module;
        this.myTarget = target;
        this.myMetaManager = ViewsMetaManager.getInstance(module.getProject());
        this.myXmlComponents = xmlComponents;
    }

    public List<RadComponent> create() throws Exception {
        this.myClassLoader = ModuleClassLoader.create(this.myTarget, this.myModule);
        ArrayList<RadComponent> components = new ArrayList<RadComponent>();
        Document document = new SAXBuilder().build((Reader)new StringReader(this.myXmlComponents), "UTF-8");
        for (Element element : document.getRootElement().getChildren("component")) {
            components.add(this.createComponent(element));
        }
        return components;
    }

    private RadComponent createComponent(Element element) throws Exception {
        MetaModel metaModel = this.myMetaManager.getModelByTag(element.getAttributeValue("tag"));
        String target = metaModel.getTarget();
        if (target != null) {
            this.myClassLoader.loadClass(target);
        }
        RadViewComponent component = RadComponentOperations.createComponent(null, metaModel);
        component.setClientProperty(KEY, element.getChild("properties"));
        for (Element childElement : element.getChildren("component")) {
            component.add(this.createComponent(childElement), null);
        }
        return component;
    }
}

