/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.graphics;

import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;

public class DesignerGraphics {
    private final Graphics myGraphics;
    private final JComponent myTarget;
    private DrawingStyle myStyle = DrawingStyle.INVALID;
    private static final int MIN_LENGTH = 10;
    private static final int ARROW_SIZE = 5;

    public DesignerGraphics(Graphics graphics, JComponent target) {
        this.myGraphics = graphics;
        this.myTarget = target;
    }

    public Graphics getGraphics() {
        return this.myGraphics;
    }

    public void useStyle(DrawingStyle style) {
        this.myStyle = style;
    }

    public static void useStroke(DrawingStyle style, Graphics gc) {
        Color strokeColor = style.getStrokeColor();
        if (strokeColor != gc.getColor()) {
            gc.setColor(strokeColor);
        }
        if (gc instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)gc;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
    }

    public static void useFill(DrawingStyle style, Graphics gc) {
        Color fillColor = style.getFillColor();
        if (fillColor != null && fillColor != gc.getColor()) {
            gc.setColor(fillColor);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        DesignerGraphics.fillRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public static void fillRect(DrawingStyle style, Graphics gc, int x, int y, int width, int height) {
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            DesignerGraphics.useFill(style, gc);
            gc.fillRect(x + 1, y + 1, width - 1, height - 1);
        }
    }

    public static void drawFilledRect(DrawingStyle style, Graphics gc, int x, int y, int width, int height) {
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            DesignerGraphics.useFill(style, gc);
            gc.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
        DesignerGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.drawRect(x, y, width - 1, height - 1);
        }
    }

    public static void drawStrokeFilledRect(DrawingStyle style, Graphics gc, int x, int y, int width, int height) {
        DesignerGraphics.useStroke(style, gc);
        if (style.getStrokeColor() != null) {
            gc.fillRect(x, y, width, height);
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        DesignerGraphics.drawRect(this.myStyle, this.myGraphics, x, y, width, height);
    }

    public static void drawRect(DrawingStyle style, Graphics gc, int x, int y, int width, int height) {
        DesignerGraphics.useStroke(style, gc);
        gc.drawRect(x, y, width - 1, height - 1);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        DesignerGraphics.drawLine(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public static void drawLine(DrawingStyle style, Graphics gc, int x1, int y1, int x2, int y2) {
        DesignerGraphics.useStroke(style, gc);
        gc.drawLine(x1, y1, x2, y2);
    }

    public void drawArrow(int x1, int y1, int x2, int y2) {
        DesignerGraphics.drawArrow(this.myStyle, this.myGraphics, x1, y1, x2, y2);
    }

    public static void drawArrow(DrawingStyle style, Graphics graphics, int x1, int y1, int x2, int y2) {
        int delta;
        Color strokeColor = style.getStrokeColor();
        if (strokeColor != graphics.getColor()) {
            graphics.setColor(strokeColor);
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D gc2 = (Graphics2D)graphics;
            Stroke stroke = style.getStroke();
            if (gc2.getStroke() != stroke) {
                gc2.setStroke(stroke);
            }
        }
        int arrowWidth = 5;
        int arrowHeight = 5;
        if (x1 == x2 && Math.abs(y1 - y2) < 10) {
            delta = (10 - Math.abs(y1 - y2)) / 2;
            if (y1 < y2) {
                y1 -= delta;
                y2 += delta;
            } else {
                y1 += delta;
                y2 -= delta;
            }
        } else if (y1 == y2 && Math.abs(x1 - x2) < 10) {
            delta = (10 - Math.abs(x1 - x2)) / 2;
            if (x1 < x2) {
                x1 -= delta;
                x2 += delta;
            } else {
                x1 += delta;
                x2 -= delta;
            }
        }
        graphics.drawLine(x1, y1, x2, y2);
        if (x1 == x2) {
            if (y2 > y1) {
                graphics.drawLine(x2 - arrowWidth, y2 - arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 - arrowHeight, x2, y2);
            } else {
                graphics.drawLine(x2 - arrowWidth, y2 + arrowHeight, x2, y2);
                graphics.drawLine(x2 + arrowWidth, y2 + arrowHeight, x2, y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                graphics.drawLine(x2 - arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 - arrowHeight, y2 + arrowWidth, x2, y2);
            } else {
                graphics.drawLine(x2 + arrowHeight, y2 - arrowWidth, x2, y2);
                graphics.drawLine(x2 + arrowHeight, y2 + arrowWidth, x2, y2);
            }
        } else {
            int dy = y2 - y1;
            int dx = x2 - x1;
            double angle = Math.atan2(dy, dx);
            double lineLength = Math.sqrt(dy * dy + dx * dx);
            double ax = (double)x1 + lineLength - (double)arrowHeight;
            double ay = y1 - arrowWidth;
            int rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            int ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
            ay = y1 + arrowWidth;
            rx = (int)(Math.cos(angle) * (ax - (double)x1) - Math.sin(angle) * (ay - (double)y1) + (double)x1);
            ry = (int)(Math.sin(angle) * (ax - (double)x1) + Math.cos(angle) * (ay - (double)y1) + (double)y1);
            graphics.drawLine(x2, y2, rx, ry);
        }
    }

    public static void drawCross(DrawingStyle style, Graphics g, int radius) {
        int size2 = (radius - 3) / 2;
        Color fillColor = style.getFillColor();
        if (fillColor != null) {
            DesignerGraphics.fillRect(style, g, 0, size2, radius, 3);
            DesignerGraphics.fillRect(style, g, size2, 0, 3, radius);
        } else {
            DesignerGraphics.drawLine(style, g, 0, size2 + 1, radius, size2 + 1);
            DesignerGraphics.drawLine(style, g, size2 + 1, 0, size2 + 1, radius);
        }
    }

    public JComponent getTarget() {
        return this.myTarget;
    }
}

