/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout;

import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.designSurface.AbstractEditOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.AlphaFeedback;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;

public class AbsoluteLayoutOperation
extends AbstractEditOperation {
    private AlphaFeedback myFeedback;
    private Rectangle myBounds;
    private Point myStartLocation;

    public AbsoluteLayoutOperation(RadComponent container, OperationContext context) {
        super(container, context);
    }

    private void createFeedback() {
        if (this.myFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            if (this.myContext.isCreate() || this.myContext.isPaste()) {
                this.myBounds = new Rectangle(0, 0, 64, 32);
            } else {
                Iterator I = this.myComponents.iterator();
                this.myBounds = ((RadComponent)I.next()).getBounds((Component)layer);
                while (I.hasNext()) {
                    this.myBounds.add(((RadComponent)I.next()).getBounds((Component)layer));
                }
                if (this.myBounds.width == 0) {
                    this.myBounds.width = 64;
                }
                if (this.myBounds.height == 0) {
                    this.myBounds.height = 32;
                }
                this.myStartLocation = this.myBounds.getLocation();
            }
            this.myFeedback = new AlphaFeedback(this.myComponents.size() == 1 ? Color.green : Color.orange);
            this.myFeedback.setSize(this.myBounds.width, this.myBounds.height);
            layer.add((Component)this.myFeedback);
            layer.repaint();
        }
    }

    public void showFeedback() {
        this.createFeedback();
        Point location = this.myContext.getLocation();
        Dimension delta = this.myContext.getSizeDelta();
        if (delta == null || delta.width == 0 && delta.height == 0 || this.myComponents.size() > 1) {
            this.myBounds.x = location.x - this.myBounds.width / 2;
            this.myBounds.y = location.y - this.myBounds.height / 2;
            this.myFeedback.setLocation(this.myBounds.x, this.myBounds.y);
        } else {
            this.myBounds.width = location.x - this.myBounds.x;
            this.myBounds.height = location.y - this.myBounds.y;
            this.myFeedback.setSize(this.myBounds.width, this.myBounds.height);
        }
    }

    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)this.myFeedback);
            layer.repaint();
            this.myFeedback = null;
        }
    }

    @Override
    public void execute() throws Exception {
        if (!this.myContext.isMove()) {
            super.execute();
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                EditableArea area = AbsoluteLayoutOperation.this.myContext.getArea();
                FeedbackLayer layer = area.getFeedbackLayer();
                Rectangle parentBounds = AbsoluteLayoutOperation.this.myContainer.getBounds();
                if (AbsoluteLayoutOperation.this.myContext.isCreate() || AbsoluteLayoutOperation.this.myContext.isPaste()) {
                    Point location = AbsoluteLayoutOperation.this.myContainer.convertPoint((Component)layer, ((AbsoluteLayoutOperation)AbsoluteLayoutOperation.this).myBounds.x, ((AbsoluteLayoutOperation)AbsoluteLayoutOperation.this).myBounds.y);
                    Dimension delta = AbsoluteLayoutOperation.this.myContext.getSizeDelta();
                    for (RadComponent component : AbsoluteLayoutOperation.this.myComponents) {
                        XmlTag tag = ((RadViewComponent)component).getTag();
                        String x = AndroidDesignerUtils.pxToDpWithUnits(area, location.x - parentBounds.x);
                        String y = AndroidDesignerUtils.pxToDpWithUnits(area, location.y - parentBounds.y);
                        tag.setAttribute("layout_x", "http://schemas.android.com/apk/res/android", x);
                        tag.setAttribute("layout_y", "http://schemas.android.com/apk/res/android", y);
                        if (delta == null || AbsoluteLayoutOperation.this.myComponents.size() != 1) continue;
                        Rectangle modelBounds = component.toModel((Component)layer, AbsoluteLayoutOperation.this.myBounds);
                        if (delta.width > 0) {
                            String width = AndroidDesignerUtils.pxToDpWithUnits(area, modelBounds.width);
                            tag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", width);
                        }
                        if (delta.height <= 0) continue;
                        String height = AndroidDesignerUtils.pxToDpWithUnits(area, modelBounds.height);
                        tag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", height);
                    }
                } else {
                    int moveDeltaX = ((AbsoluteLayoutOperation)AbsoluteLayoutOperation.this).myBounds.x - ((AbsoluteLayoutOperation)AbsoluteLayoutOperation.this).myStartLocation.x;
                    int moveDeltaY = ((AbsoluteLayoutOperation)AbsoluteLayoutOperation.this).myBounds.y - ((AbsoluteLayoutOperation)AbsoluteLayoutOperation.this).myStartLocation.y;
                    for (RadComponent component : AbsoluteLayoutOperation.this.myComponents) {
                        Rectangle bounds = component.getBounds((Component)layer);
                        Point location = component.convertPoint((Component)layer, bounds.x + moveDeltaX, bounds.y + moveDeltaY);
                        XmlTag tag = ((RadViewComponent)component).getTag();
                        String x = AndroidDesignerUtils.pxToDpWithUnits(area, location.x - parentBounds.x);
                        String y = AndroidDesignerUtils.pxToDpWithUnits(area, location.y - parentBounds.y);
                        tag.setAttribute("layout_x", "http://schemas.android.com/apk/res/android", x);
                        tag.setAttribute("layout_y", "http://schemas.android.com/apk/res/android", y);
                    }
                }
            }
        });
    }
}

