/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface.layout.actions;

import com.android.tools.idea.designer.Insets;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.RectangleFeedback;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.designSurface.selection.EmptyPoint;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Locale;
import javax.swing.border.Border;

public class LayoutMarginOperation
implements EditOperation {
    public static final String TYPE = "layout_margin";
    protected final OperationContext myContext;
    protected RadViewComponent myComponent;
    protected RectangleFeedback myFeedback;
    protected TextFeedback myTextFeedback;
    private Rectangle myBounds;
    protected Insets myMargins;

    public LayoutMarginOperation(OperationContext context) {
        this.myContext = context;
    }

    public void setComponent(RadComponent component) {
        this.myComponent = (RadViewComponent)component;
        this.myBounds = this.myComponent.getBounds((Component)this.myContext.getArea().getFeedbackLayer());
        this.myMargins = this.myComponent.getMargins();
    }

    public void setComponents(List<RadComponent> components) {
    }

    private void createFeedback() {
        if (this.myFeedback == null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            this.myTextFeedback = new TextFeedback();
            this.myTextFeedback.setBorder((Border)new LineMarginBorder(0, 5, 3, 0));
            layer.add((Component)((Object)this.myTextFeedback));
            this.myFeedback = new RectangleFeedback(DrawingStyle.MARGIN_BOUNDS);
            layer.add((Component)((Object)this.myFeedback));
            layer.repaint();
        }
    }

    public void showFeedback() {
        this.createFeedback();
        Rectangle bounds = this.myContext.getTransformedRectangle(this.myBounds);
        FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
        this.myComponent.getMargins((Component)layer).subtractFrom(bounds);
        this.myFeedback.setBounds(bounds);
        this.myTextFeedback.clear();
        this.fillTextFeedback();
        this.myTextFeedback.locationTo(this.myContext.getLocation(), 15);
    }

    protected void fillTextFeedback() {
        EditableArea area = this.myContext.getArea();
        FeedbackLayer layer = area.getFeedbackLayer();
        Dimension moveDelta = this.myComponent.toModel((Component)layer, new Dimension(this.myContext.getMoveDelta().x, this.myContext.getMoveDelta().y));
        Dimension sizeDelta = this.myComponent.toModel((Component)layer, this.myContext.getSizeDelta());
        int direction = this.myContext.getResizeDirection();
        if (direction == 4) {
            this.myTextFeedback.append(AndroidDesignerUtils.pxToDpWithUnits(area, this.myMargins.left - moveDelta.width));
        } else if (direction == 8) {
            this.myTextFeedback.append(AndroidDesignerUtils.pxToDpWithUnits(area, this.myMargins.right + sizeDelta.width));
        } else if (direction == 1) {
            this.myTextFeedback.append(AndroidDesignerUtils.pxToDpWithUnits(area, this.myMargins.top - moveDelta.height));
        } else if (direction == 2) {
            this.myTextFeedback.append(AndroidDesignerUtils.pxToDpWithUnits(area, this.myMargins.bottom + sizeDelta.height));
        }
    }

    public void eraseFeedback() {
        if (this.myFeedback != null) {
            FeedbackLayer layer = this.myContext.getArea().getFeedbackLayer();
            layer.remove((Component)((Object)this.myTextFeedback));
            layer.remove((Component)((Object)this.myFeedback));
            layer.repaint();
            this.myTextFeedback = null;
            this.myFeedback = null;
        }
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag tag = LayoutMarginOperation.this.myComponent.getTag();
                XmlAttribute margin = tag.getAttribute(LayoutMarginOperation.TYPE, "http://schemas.android.com/apk/res/android");
                if (margin != null) {
                    String value = margin.getValue();
                    margin.delete();
                    if (!StringUtil.isEmpty((String)value)) {
                        tag.setAttribute("layout_marginLeft", "http://schemas.android.com/apk/res/android", value);
                        tag.setAttribute("layout_marginRight", "http://schemas.android.com/apk/res/android", value);
                        tag.setAttribute("layout_marginTop", "http://schemas.android.com/apk/res/android", value);
                        tag.setAttribute("layout_marginBottom", "http://schemas.android.com/apk/res/android", value);
                    }
                }
                FeedbackLayer layer = LayoutMarginOperation.this.myContext.getArea().getFeedbackLayer();
                Dimension moveDelta = LayoutMarginOperation.this.myComponent.toModel((Component)layer, new Dimension(LayoutMarginOperation.this.myContext.getMoveDelta().x, LayoutMarginOperation.this.myContext.getMoveDelta().y));
                Dimension sizeDelta = LayoutMarginOperation.this.myComponent.toModel((Component)layer, LayoutMarginOperation.this.myContext.getSizeDelta());
                int direction = LayoutMarginOperation.this.myContext.getResizeDirection();
                if (direction == 4) {
                    LayoutMarginOperation.this.setValue(tag, "layout_marginLeft", LayoutMarginOperation.this.myMargins.left - moveDelta.width);
                } else if (direction == 8) {
                    LayoutMarginOperation.this.setValue(tag, "layout_marginRight", LayoutMarginOperation.this.myMargins.right + sizeDelta.width);
                } else if (direction == 1) {
                    LayoutMarginOperation.this.setValue(tag, "layout_marginTop", LayoutMarginOperation.this.myMargins.top - moveDelta.height);
                } else if (direction == 2) {
                    LayoutMarginOperation.this.setValue(tag, "layout_marginBottom", LayoutMarginOperation.this.myMargins.bottom + sizeDelta.height);
                }
            }
        });
    }

    private void setValue(XmlTag tag, String name, int pxValue) {
        int value = AndroidDesignerUtils.pxToDp(this.myContext.getArea(), pxValue);
        if (value == 0) {
            RadComponentOperations.deleteAttribute(tag, name);
        } else {
            tag.setAttribute(name, "http://schemas.android.com/apk/res/android", String.format(Locale.US, "%ddp", value));
        }
    }

    public static void points(ResizeSelectionDecorator decorator) {
        LayoutMarginOperation.pointFeedback(decorator);
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.MARGIN_HANDLE, 4, TYPE, "Change layout:margin.left"){

            @Override
            protected Point getLocation(DecorationLayer layer, RadComponent component) {
                Point location = super.getLocation(layer, component);
                int marginLeft = ((RadViewComponent)component).getMargins((Component)layer).left;
                location.x -= marginLeft;
                return location;
            }
        });
        LayoutMarginOperation.pointRight(decorator, DrawingStyle.MARGIN_HANDLE, 0.25, TYPE, "Change layout:margin.right");
        decorator.addPoint((ResizePoint)new DirectionResizePoint(DrawingStyle.MARGIN_HANDLE, 1, TYPE, "Change layout:margin.top"){

            @Override
            protected Point getLocation(DecorationLayer layer, RadComponent component) {
                Point location = super.getLocation(layer, component);
                int marginTop = ((RadViewComponent)component).getMargins((Component)layer).top;
                location.y -= marginTop;
                return location;
            }
        });
        LayoutMarginOperation.pointBottom(decorator, DrawingStyle.MARGIN_HANDLE, 0.25, TYPE, "Change layout:margin.bottom");
    }

    protected static void pointFeedback(ResizeSelectionDecorator decorator) {
        decorator.addPoint((ResizePoint)new EmptyPoint(){

            protected void paint(DecorationLayer layer, Graphics2D g, RadComponent component) {
                Rectangle bounds = component.getBounds((Component)layer);
                Insets margins = ((RadViewComponent)component).getMargins((Component)layer);
                if (!margins.isEmpty()) {
                    margins.subtractFrom(bounds);
                    DesignerGraphics.drawRect(DrawingStyle.MARGIN_BOUNDS, g, bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        });
    }

    protected static void pointRight(ResizeSelectionDecorator decorator, DrawingStyle style, double ySeparator, Object type, String description) {
        decorator.addPoint((ResizePoint)new DirectionResizePoint(style, 8, type, description){

            @Override
            protected Point getLocation(DecorationLayer layer, RadComponent component) {
                Point location = super.getLocation(layer, component);
                int marginRight = ((RadViewComponent)component).getMargins((Component)layer).right;
                location.x += marginRight;
                return location;
            }
        }.move(1.0, ySeparator));
    }

    protected static void pointBottom(ResizeSelectionDecorator decorator, DrawingStyle style, double xSeparator, Object type, String description) {
        decorator.addPoint((ResizePoint)new DirectionResizePoint(style, 2, type, description){

            @Override
            protected Point getLocation(DecorationLayer layer, RadComponent component) {
                Point location = super.getLocation(layer, component);
                int marginBottom = ((RadViewComponent)component).getMargins((Component)layer).bottom;
                location.y += marginBottom;
                return location;
            }
        }.move(xSeparator, 1.0));
    }
}

