/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewContainer;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IdManager {
    public static IdManager get() {
        return new IdManager();
    }

    public static String getIdName(String idValue) {
        if (idValue != null) {
            if (idValue.startsWith("@+id/")) {
                return idValue.substring("@+id/".length());
            }
            if (idValue.startsWith("@id/")) {
                return idValue.substring("@id/".length());
            }
        }
        return null;
    }

    private static Collection<String> getIds(RadViewComponent component) {
        XmlTag tag = component.getTag();
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)tag);
        return IdManager.getIds(module, component.getRoot());
    }

    private static Collection<String> getIds(Module module, RadComponent root) {
        AppResourceRepository resources;
        HashSet ids = Sets.newHashSet();
        if (root != null) {
            IdManager.addIdsFromChildren(root, ids);
        }
        if (module != null && (resources = AppResourceRepository.getAppResources(module, true)) != null) {
            ids.addAll(resources.getItemsOfType(ResourceType.ID));
        }
        return ids;
    }

    private static void addIdsFromChildren(RadComponent root, final Set<String> ids) {
        root.accept(new RadComponentVisitor(){

            public void endVisit(RadComponent component) {
                RadViewComponent viewComponent;
                String id;
                if (component instanceof RadViewComponent && (id = IdManager.getIdName((viewComponent = (RadViewComponent)component).getId())) != null) {
                    ids.add(id);
                }
            }
        }, true);
    }

    public String assignId(RadViewComponent component) {
        XmlTag tag = component.getTag();
        Collection<String> idList = IdManager.getIds(AndroidPsiUtils.getModuleSafely((PsiElement)tag), component.getRoot());
        return this.assignId(component, idList);
    }

    public String assignId(RadViewComponent component, Collection<String> idList) {
        String idValue = StringUtil.decapitalize((String)component.getMetaModel().getTag());
        XmlTag tag = component.getTag();
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)tag);
        if (module != null) {
            idValue = ResourceHelper.prependResourcePrefix(module, idValue);
        }
        String nextIdValue = idValue;
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        Project project = tag.getProject();
        while (idList.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + Integer.toString(index);
        }
        String newId = "@+id/" + idValue + (index == 0 ? "" : Integer.toString(index));
        tag.setAttribute("id", "http://schemas.android.com/apk/res/android", newId);
        return newId;
    }

    public boolean needsDefaultId(RadViewComponent component) {
        if (component instanceof RadViewContainer) {
            return false;
        }
        String tag = component.getTag().getName();
        return !tag.equals("include") && !tag.equals("merge") && !tag.equals("Space") && !tag.equals("requestFocus") && (!tag.endsWith("Space") || tag.length() <= "Space".length() || tag.charAt(tag.length() - "Space".length()) != '.');
    }

    public void ensureIds(final RadViewComponent container) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                final ArrayList replaceList = new ArrayList();
                final ArrayList idList = Lists.newArrayList((Iterable)IdManager.getIds(container));
                container.accept(new RadComponentVisitor(){

                    public void endVisit(RadComponent component) {
                        RadViewComponent viewComponent = (RadViewComponent)component;
                        String id = viewComponent.getId();
                        String idName = IdManager.getIdName(id);
                        if (component == container) {
                            if (idName != null || IdManager.this.needsDefaultId(viewComponent)) {
                                id = IdManager.this.assignId(viewComponent, idList);
                                idList.add(IdManager.getIdName(id));
                            }
                        } else if (idName != null && idList.contains(idName)) {
                            id = IdManager.this.assignId(viewComponent, idList);
                            idList.add(IdManager.getIdName(id));
                            replaceList.add(Pair.create((Object)Pair.create((Object)("@id/" + idName), (Object)("@+id/" + idName)), (Object)id));
                        }
                    }
                }, true);
                if (!replaceList.isEmpty()) {
                    IdManager.replaceIds(container, replaceList);
                }
            }
        });
    }

    private static void replaceIds(RadViewComponent container, final List<Pair<Pair<String, String>, String>> replaceList) {
        container.accept(new RadComponentVisitor(){

            public void endVisit(RadComponent component) {
                XmlTag tag = ((RadViewComponent)component).getTag();
                block0: for (XmlAttribute attribute : tag.getAttributes()) {
                    String value = attribute.getValue();
                    for (Pair replace : replaceList) {
                        if (!((String)((Pair)replace.first).first).equals(value) && !((String)((Pair)replace.first).second).equals(value)) continue;
                        attribute.setValue((String)replace.second);
                        continue block0;
                    }
                }
            }
        }, true);
    }
}

