/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.intellij.android.designer.model.IConfigurableComponent;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.propertyTable.CustomViewProperty;
import com.intellij.designer.ModuleProvider;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.model.IComponentDecorator;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import org.jetbrains.android.uipreview.ChooseClassDialog;

public class RadCustomViewComponent
extends RadViewComponent
implements IConfigurableComponent,
IComponentDecorator {
    private static final String NAME_KEY = "view.name";
    public static final String MODEL_KEY = "view.model";
    private static final Property CLASS_PROPERTY = new CustomViewProperty();

    @Override
    public String getCreationXml() {
        return "<" + this.getClientProperty(NAME_KEY) + "\n" + "android:layout_width=\"wrap_content\"\n" + "android:layout_height=\"wrap_content\"/>";
    }

    @Override
    public void configure(RadComponent rootComponent) throws Exception {
        String view = RadCustomViewComponent.chooseView(rootComponent);
        if (view == null) {
            throw new Exception();
        }
        this.setClientProperty(NAME_KEY, view);
    }

    public static String chooseView(RadComponent rootComponent) {
        ModuleProvider moduleProvider = RadModelBuilder.getModuleProvider(rootComponent);
        if (moduleProvider == null) {
            return null;
        }
        ChooseClassDialog dialog = new ChooseClassDialog(moduleProvider.getModule(), "Views", false, new String[0]){

            @Override
            protected void findClasses(Module module, boolean includeAll, DefaultListModel model, String[] classes) {
                HashSet<String> names = new HashSet<String>();
                for (PsiClass psiClass : 1.findInheritors(module, "android.view.View", false)) {
                    model.addElement(psiClass);
                    names.add(psiClass.getQualifiedName());
                }
                for (PsiClass psiClass : 1.findInheritors(module, "android.view.View", true)) {
                    String name = psiClass.getQualifiedName();
                    if (names.contains(name) || name == null || name.startsWith("android.") && !name.startsWith("android.support")) continue;
                    model.addElement(psiClass);
                }
            }
        };
        if (dialog.showAndGet()) {
            return dialog.getClassName();
        }
        return null;
    }

    public String getViewClass() {
        XmlTag tag = this.getTag();
        String tagName = tag.getName();
        if (!StringUtil.isEmpty((String)tagName) && !tagName.equals("view")) {
            return tagName;
        }
        String classAttribute = tag.getAttributeValue("class");
        if (!StringUtil.isEmpty((String)classAttribute)) {
            return classAttribute;
        }
        return null;
    }

    public void decorateTree(SimpleColoredComponent renderer, AttributeWrapper wrapper) {
        String viewClass = this.getViewClass();
        if (viewClass != null) {
            renderer.append(" - " + viewClass, wrapper.getAttribute(SimpleTextAttributes.REGULAR_ATTRIBUTES));
        }
    }

    public MetaModel getMetaModelForProperties() throws Exception {
        MetaModel metaModel = (MetaModel)this.getClientProperty(MODEL_KEY);
        if (metaModel == null) {
            ModuleProvider moduleProvider = RadModelBuilder.getModuleProvider(this.getRoot());
            assert (moduleProvider != null);
            ViewsMetaManager metaManager = ViewsMetaManager.getInstance(moduleProvider.getProject());
            for (PsiClass viewClass = ChooseClassDialog.findClass(moduleProvider.getModule(), this.getViewClass()); viewClass != null && (metaModel = metaManager.getModelByTarget(viewClass.getQualifiedName())) == null; viewClass = viewClass.getSuperClass()) {
            }
            if (metaModel == null) {
                metaModel = this.myMetaModel;
            }
            this.setClientProperty(MODEL_KEY, metaModel);
        }
        return metaModel;
    }

    @Override
    public List<Property> getInplaceProperties() throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        MetaModel metaModel = this.getMetaModelForProperties();
        List<Property> allProperties = this.getProperties();
        properties.add(CLASS_PROPERTY);
        for (String name : metaModel.getInplaceProperties()) {
            Property property = PropertyTable.findProperty(allProperties, (String)name);
            if (property == null) continue;
            properties.add(property);
        }
        properties.add(PropertyTable.findProperty(allProperties, (String)"id"));
        return properties;
    }

    @Override
    public void setProperties(List<Property> properties) {
        if (!properties.contains(CLASS_PROPERTY)) {
            properties = new ArrayList<Property>(properties);
            properties.add(0, CLASS_PROPERTY);
        }
        super.setProperties(properties);
    }
}

