/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.designer.AndroidMetaModel;
import com.android.tools.idea.designer.Insets;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.intellij.android.designer.AndroidDesignerUtils;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.designSurface.TransformedComponent;
import com.intellij.android.designer.model.ComponentMorphingTool;
import com.intellij.android.designer.model.IdManager;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ScalableComponent;
import com.intellij.designer.model.EmptyXmlTag;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.hash.HashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdom.Element;

public class RadViewComponent
extends RadVisualComponent {
    private final List<RadComponent> myChildren = new ArrayList<RadComponent>();
    protected ViewInfo myViewInfo;
    private Insets myMargins;
    private Insets myPadding;
    private XmlTag myTag;
    private List<Property> myProperties;
    private PaletteItem myPaletteItem;
    private static final int WRAP_CONTENT = 0;

    public XmlTag getTag() {
        if (this.myTag == null || this.myTag.getParent() == null || !this.myTag.isValid()) {
            return EmptyXmlTag.INSTANCE;
        }
        return this.myTag;
    }

    public void setTag(XmlTag tag) {
        this.myTag = tag;
    }

    public String getAttribute(String name, String namespace) {
        if (namespace != null) {
            return this.myTag.getAttributeValue(name, namespace);
        }
        return this.myTag.getAttributeValue(name);
    }

    public void setAttribute(String name, String namespace, String value) {
        if (namespace != null) {
            this.myTag.setAttribute(name, namespace, value);
        } else {
            this.myTag.setAttribute(name, value);
        }
    }

    public void updateTag(XmlTag tag) {
        this.setTag(tag);
        int size = this.myChildren.size();
        XmlTag[] tags = tag.getSubTags();
        for (int i = 0; i < size; ++i) {
            RadViewComponent child = (RadViewComponent)this.myChildren.get(i);
            child.updateTag(tags[i]);
        }
    }

    public String getCreationXml() {
        throw new UnsupportedOperationException();
    }

    public ViewInfo getViewInfo() {
        return this.myViewInfo;
    }

    public void setViewInfo(ViewInfo viewInfo) {
        this.myViewInfo = viewInfo;
        this.myMargins = null;
    }

    public AndroidMetaModel getMetaModel() {
        return (AndroidMetaModel)super.getMetaModel();
    }

    public String ensureId() {
        String id = this.getId();
        if (id == null) {
            id = IdManager.get().assignId(this);
        }
        return id;
    }

    public String getId() {
        return StringUtil.nullize((String)this.getTag().getAttributeValue("id", "http://schemas.android.com/apk/res/android"), (boolean)false);
    }

    public int getBaseline() {
        try {
            Object viewObject = this.myViewInfo.getViewObject();
            return (Integer)viewObject.getClass().getMethod("getBaseline", new Class[0]).invoke(viewObject, new Object[0]);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public Insets getMargins() {
        if (this.myMargins == null) {
            try {
                Object layoutParams = this.myViewInfo.getLayoutParamsObject();
                Class<?> layoutClass = layoutParams.getClass();
                int left = RadViewComponent.fixDefault(layoutClass.getField("leftMargin").getInt(layoutParams));
                int top = RadViewComponent.fixDefault(layoutClass.getField("topMargin").getInt(layoutParams));
                int right = RadViewComponent.fixDefault(layoutClass.getField("rightMargin").getInt(layoutParams));
                int bottom = RadViewComponent.fixDefault(layoutClass.getField("bottomMargin").getInt(layoutParams));
                this.myMargins = left == 0 && top == 0 && right == 0 && bottom == 0 ? Insets.NONE : new Insets(left, top, right, bottom);
            }
            catch (Throwable e) {
                this.myMargins = Insets.NONE;
            }
        }
        return this.myMargins;
    }

    public Insets getPadding() {
        if (this.myPadding == null) {
            try {
                Object layoutParams = this.myViewInfo.getViewObject();
                Class<?> layoutClass = layoutParams.getClass();
                int left = RadViewComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingLeft", new Class[0]).invoke(layoutParams, new Object[0]));
                int top = RadViewComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingTop", new Class[0]).invoke(layoutParams, new Object[0]));
                int right = RadViewComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingRight", new Class[0]).invoke(layoutParams, new Object[0]));
                int bottom = RadViewComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingBottom", new Class[0]).invoke(layoutParams, new Object[0]));
                this.myPadding = left == 0 && top == 0 && right == 0 && bottom == 0 ? Insets.NONE : new Insets(left, top, right, bottom);
            }
            catch (Throwable e) {
                this.myPadding = Insets.NONE;
            }
        }
        return this.myPadding;
    }

    public Insets getMargins(Component relativeTo) {
        Insets margins = this.getMargins();
        if (margins.isEmpty()) {
            return margins;
        }
        return this.fromModel(relativeTo, margins);
    }

    public Insets getPadding(Component relativeTo) {
        Insets padding = this.getPadding();
        if (padding.isEmpty()) {
            return padding;
        }
        return this.fromModel(relativeTo, padding);
    }

    private static int fixDefault(int value) {
        return value == Integer.MIN_VALUE ? 0 : value;
    }

    public boolean calculateWrapSize(Dimension wrapSize, Rectangle bounds) {
        block6: {
            if (wrapSize.width == -1 || wrapSize.height == -1) {
                try {
                    Object viewObject = this.myViewInfo.getViewObject();
                    Class<?> viewClass = viewObject.getClass();
                    viewClass.getMethod("forceLayout", new Class[0]).invoke(viewObject, new Object[0]);
                    viewClass.getMethod("measure", Integer.TYPE, Integer.TYPE).invoke(viewObject, 0, 0);
                    if (wrapSize.width == -1) {
                        wrapSize.width = (Integer)viewClass.getMethod("getMeasuredWidth", new Class[0]).invoke(viewObject, new Object[0]);
                    }
                    if (wrapSize.height == -1) {
                        wrapSize.height = (Integer)viewClass.getMethod("getMeasuredHeight", new Class[0]).invoke(viewObject, new Object[0]);
                    }
                    return true;
                }
                catch (Throwable e) {
                    if (bounds == null) break block6;
                    if (wrapSize.width == -1) {
                        wrapSize.width = bounds.width;
                    }
                    if (wrapSize.height != -1) break block6;
                    wrapSize.height = bounds.height;
                }
            }
        }
        return false;
    }

    public Dimension calculateWrapSize(EditableArea area) {
        Dimension dimension;
        boolean measured;
        if (this.myViewInfo != null && (measured = this.calculateWrapSize(dimension = new Dimension(-1, -1), null))) {
            return dimension;
        }
        RadComponent parent = this.getParent();
        if (!(parent instanceof RadViewComponent)) {
            return null;
        }
        XmlTag parentTag = ((RadViewComponent)parent).getTag();
        if (parentTag != null) {
            RenderTask task = AndroidDesignerUtils.createRenderTask(area);
            if (task == null) {
                return null;
            }
            ViewInfo viewInfo = task.measureChild(this.getTag(), new RenderTask.AttributeFilter(){

                @Override
                public String getAttribute(XmlTag n, String namespace, String localName) {
                    if (("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                        return "wrap_content";
                    }
                    if ("layout_weight".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                        return "";
                    }
                    return null;
                }
            });
            if (viewInfo != null) {
                viewInfo = RenderService.getSafeBounds(viewInfo);
                return new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
            }
        }
        return null;
    }

    public List<RadComponent> getChildren() {
        return this.myChildren;
    }

    public boolean isBackground() {
        RadComponent parent = this.getParent();
        if (parent != null && parent.getParent() == null && !parent.getMetaModel().isTag("merge")) {
            IncludeReference includeContext = (IncludeReference)parent.getClientProperty("showIn");
            return includeContext == null || includeContext == IncludeReference.NONE;
        }
        return parent == null;
    }

    public boolean canDelete() {
        RadComponent parent = this.getParent();
        if (parent == null || parent.getParent() == null && !parent.getMetaModel().isTag("merge")) {
            return false;
        }
        return super.canDelete();
    }

    public void delete() throws Exception {
        if (this.getParent() != null) {
            this.removeFromParent();
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                RadViewComponent.this.myTag.delete();
            }
        });
    }

    public List<Property> getProperties() {
        return this.myProperties;
    }

    public void setProperties(List<Property> properties) {
        this.myProperties = properties;
    }

    public List<Property> getInplaceProperties() throws Exception {
        List properties = super.getInplaceProperties();
        Property idProperty = PropertyTable.findProperty(this.myProperties, (String)"id");
        if (idProperty != null) {
            properties.add(idProperty);
        }
        return properties;
    }

    public void copyTo(Element parent) throws Exception {
        if (this.getParent() != null) {
            Element component = new Element("component");
            component.setAttribute("tag", this.myTag.getName());
            XmlAttribute[] attributes = this.myTag.getAttributes();
            if (attributes.length > 0) {
                Element properties = new Element("properties");
                component.addContent(properties);
                HashMap namespaces = new HashMap();
                for (XmlAttribute attribute : attributes) {
                    String namespace = attribute.getNamespacePrefix();
                    if (namespace.length() == 0) {
                        properties.setAttribute(attribute.getName(), attribute.getValue());
                        continue;
                    }
                    Element element = (Element)namespaces.get(namespace);
                    if (element == null) {
                        element = new Element(namespace);
                        namespaces.put(namespace, element);
                    }
                    element.setAttribute(attribute.getLocalName(), attribute.getValue());
                }
                for (Element element : namespaces.values()) {
                    properties.addContent(element);
                }
            }
            parent.addContent(component);
            parent = component;
        }
        for (RadComponent child : this.myChildren) {
            child.copyTo(parent);
        }
    }

    public boolean isSameType(RadComponent other) {
        if (this.myTag != null) {
            if (!(other instanceof RadViewComponent)) {
                return false;
            }
            RadViewComponent otherView = (RadViewComponent)other;
            if (otherView.myTag == null) {
                return false;
            }
            return this.myTag.getName().equals(otherView.myTag.getName());
        }
        return super.isSameType(other);
    }

    public RadComponent morphingTo(MetaModel target) throws Exception {
        return new ComponentMorphingTool(this, this, target, null).result();
    }

    public void setInitialPaletteItem(PaletteItem paletteItem) {
        this.myPaletteItem = paletteItem;
    }

    public PaletteItem getInitialPaletteItem() {
        return this.myPaletteItem;
    }

    public Rectangle toModelDp(int dpi, Component source, Rectangle rectangle) {
        Component nativeComponent = this.getNativeComponent();
        Rectangle bounds = nativeComponent == source ? rectangle : SwingUtilities.convertRectangle(source, rectangle, nativeComponent);
        double x = 160 * bounds.x;
        double y = 160 * bounds.y;
        double w = 160 * bounds.width;
        double h = 160 * bounds.height;
        if (nativeComponent != source && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            x -= (double)transform.getShiftX();
            y -= (double)transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0) {
                x /= zoom;
                y /= zoom;
                w /= zoom;
                h /= zoom;
            }
        }
        double dpiDouble = dpi;
        return new Rectangle((int)(x / dpiDouble), (int)(y / dpiDouble), (int)(w / dpiDouble), (int)(h / dpiDouble));
    }

    public Point toModelDp(int dpi, Component source, Point point) {
        Component nativeComponent = this.getNativeComponent();
        Point bounds = nativeComponent == source ? point : SwingUtilities.convertPoint(source, point, nativeComponent);
        double x = 160 * bounds.x;
        double y = 160 * bounds.y;
        if (nativeComponent != source && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            x -= (double)transform.getShiftX();
            y -= (double)transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0) {
                x /= zoom;
                y /= zoom;
            }
        }
        double dpiDouble = dpi;
        return new Point((int)(x / dpiDouble), (int)(y / dpiDouble));
    }

    public Dimension toModelDp(int dpi, Component source, Dimension size) {
        ScalableComponent scalableComponent;
        double zoom;
        Component nativeComponent = this.getNativeComponent();
        size = new Dimension(size);
        double w = 160 * size.width;
        double h = 160 * size.height;
        if (nativeComponent != source && nativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)nativeComponent).getScale()) != 1.0) {
            w /= zoom;
            h /= zoom;
        }
        double dpiDouble = dpi;
        return new Dimension((int)(w / dpiDouble), (int)(h / dpiDouble));
    }

    public Insets fromModel(Component target, Insets insets) {
        ScalableComponent scalableComponent;
        double zoom;
        if (insets.isEmpty()) {
            return insets;
        }
        Component nativeComponent = this.getNativeComponent();
        if (target != nativeComponent && nativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)nativeComponent).getScale()) != 1.0) {
            return new Insets((int)((double)insets.left * zoom), (int)((double)insets.top * zoom), (int)((double)insets.right * zoom), (int)((double)insets.bottom * zoom));
        }
        return insets;
    }

    public Insets toModel(Component source, Insets insets) {
        ScalableComponent scalableComponent;
        double zoom;
        if (insets.isEmpty()) {
            return insets;
        }
        Component nativeComponent = this.getNativeComponent();
        if (source != nativeComponent && nativeComponent instanceof ScalableComponent && (zoom = (scalableComponent = (ScalableComponent)nativeComponent).getScale()) != 1.0) {
            return new Insets((int)((double)insets.left / zoom), (int)((double)insets.top / zoom), (int)((double)insets.right / zoom), (int)((double)insets.bottom / zoom));
        }
        return insets;
    }

    public Rectangle getPaddedBounds() {
        Rectangle bounds = this.getBounds();
        Insets padding = this.getPadding();
        if (padding == Insets.NONE) {
            return bounds;
        }
        return new Rectangle(bounds.x + padding.left, bounds.y + padding.top, Math.max(0, bounds.width - padding.left - padding.right), Math.max(0, bounds.height - padding.top - padding.bottom));
    }

    public Rectangle getPaddedBounds(Component relativeTo) {
        return this.fromModel(relativeTo, this.getPaddedBounds());
    }

    public static List<RadViewComponent> getViewComponents(List<? extends RadComponent> components) {
        for (RadComponent radComponent : components) {
            if (radComponent instanceof RadViewComponent) continue;
            ArrayList<RadViewComponent> newList = new ArrayList<RadViewComponent>(components.size() - 1);
            for (RadComponent radComponent2 : components) {
                if (!(radComponent2 instanceof RadViewComponent)) continue;
                newList.add((RadViewComponent)radComponent2);
            }
            return newList;
        }
        return components;
    }

    public boolean addPopupActions(AndroidDesignerEditorPanel designer, DefaultActionGroup beforeGroup, DefaultActionGroup afterGroup, JComponent shortcuts, List<RadComponent> selection) {
        return false;
    }

    public Rectangle fromModel(Component target, Rectangle bounds) {
        Component nativeComponent = this.getNativeComponent();
        if (target != nativeComponent && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            int shiftX = transform.getShiftX();
            int shiftY = transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0 || shiftX != 0 || shiftY != 0) {
                bounds = new Rectangle(bounds);
                bounds.x = (int)((double)bounds.x * zoom);
                bounds.y = (int)((double)bounds.y * zoom);
                bounds.width = (int)((double)bounds.width * zoom);
                bounds.height = (int)((double)bounds.height * zoom);
                bounds.x += shiftX;
                bounds.y += shiftY;
            }
        }
        return nativeComponent == target ? new Rectangle(bounds) : SwingUtilities.convertRectangle(nativeComponent, bounds, target);
    }

    public Rectangle toModel(Component source, Rectangle rectangle) {
        Rectangle bounds;
        Component nativeComponent = this.getNativeComponent();
        Rectangle rectangle2 = bounds = nativeComponent == source ? new Rectangle(rectangle) : SwingUtilities.convertRectangle(source, rectangle, nativeComponent);
        if (nativeComponent != source && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            bounds.x -= transform.getShiftX();
            bounds.y -= transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0) {
                bounds = new Rectangle(bounds);
                bounds.x = (int)((double)bounds.x / zoom);
                bounds.y = (int)((double)bounds.y / zoom);
                bounds.width = (int)((double)bounds.width / zoom);
                bounds.height = (int)((double)bounds.height / zoom);
            }
        }
        return bounds;
    }

    public Point fromModel(Component target, Point point) {
        Component nativeComponent = this.getNativeComponent();
        if (target != nativeComponent && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            int shiftX = transform.getShiftX();
            int shiftY = transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0 || shiftX != 0 || shiftY != 0) {
                point = new Point(point);
                point.x = (int)((double)point.x * zoom);
                point.y = (int)((double)point.y * zoom);
                point.x += shiftX;
                point.y += shiftY;
            }
        }
        return nativeComponent == target ? new Point(point) : SwingUtilities.convertPoint(nativeComponent, point, target);
    }

    public Point toModel(Component source, Point point) {
        Point p;
        Component nativeComponent = this.getNativeComponent();
        Point point2 = p = nativeComponent == source ? new Point(point) : SwingUtilities.convertPoint(source, point, nativeComponent);
        if (nativeComponent != source && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            p.x -= transform.getShiftX();
            p.y -= transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0) {
                p = new Point(p);
                p.x = (int)((double)p.x / zoom);
                p.y = (int)((double)p.y / zoom);
            }
        }
        return p;
    }

    public Point convertPoint(Component relativeFrom, int x, int y) {
        Point p;
        Component nativeComponent = this.getNativeComponent();
        Point point = p = nativeComponent == relativeFrom ? new Point(x, y) : SwingUtilities.convertPoint(relativeFrom, x, y, nativeComponent);
        if (nativeComponent != relativeFrom && nativeComponent instanceof TransformedComponent) {
            TransformedComponent transform = (TransformedComponent)((Object)nativeComponent);
            p.x -= transform.getShiftX();
            p.y -= transform.getShiftY();
            double zoom = transform.getScale();
            if (zoom != 1.0) {
                p.x = (int)((double)p.x / zoom);
                p.y = (int)((double)p.y / zoom);
            }
        }
        return p;
    }
}

