/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.actions.ClearWeightsAction;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ThrowableRunnable;
import icons.AndroidDesignerIcons;
import java.awt.Component;
import java.util.List;

public class AssignWeightAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private final List<? extends RadViewComponent> mySelectedChildren;

    public AssignWeightAction(DesignerEditorPanel designer, RadViewComponent layout, List<? extends RadViewComponent> selectedChildren) {
        super(designer, "Change Layout Weight", null, AndroidDesignerIcons.Weights);
        this.myLayout = layout;
        this.mySelectedChildren = selectedChildren;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        InputValidator validator;
        String title;
        String weight;
        final List<? extends RadViewComponent> targets = this.mySelectedChildren;
        if (targets.isEmpty()) {
            return;
        }
        String currentWeight = targets.get(0).getTag().getAttributeValue("layout_weight", "http://schemas.android.com/apk/res/android");
        if (currentWeight == null || currentWeight.isEmpty()) {
            currentWeight = "0.0";
        }
        if ((weight = Messages.showInputDialog((Component)this.myDesigner, (String)"Enter Weight Value:", (String)(title = this.getTemplatePresentation().getDescription()), null, (String)currentWeight, validator = null)) != null) {
            this.myDesigner.getToolProvider().execute((ThrowableRunnable)new ThrowableRunnable<Exception>(){

                public void run() throws Exception {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            if (weight.isEmpty()) {
                                ClearWeightsAction.clearWeights(AssignWeightAction.this.myLayout, targets);
                            } else {
                                for (RadViewComponent target : targets) {
                                    target.getTag().setAttribute("layout_weight", "http://schemas.android.com/apk/res/android", weight);
                                }
                            }
                        }
                    });
                }
            }, this.getTemplatePresentation().getDescription(), true);
        }
    }

    @Override
    protected void performWriteAction() {
        assert (false);
    }
}

