/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.actions;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.RadLinearLayout;
import com.intellij.android.designer.model.layout.actions.LayoutAction;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.psi.xml.XmlAttribute;
import icons.AndroidDesignerIcons;
import java.util.List;

public class ClearWeightsAction
extends LayoutAction {
    private final RadViewComponent myLayout;
    private final List<? extends RadViewComponent> mySelectedChildren;

    public ClearWeightsAction(DesignerEditorPanel designer, RadViewComponent layout, List<? extends RadViewComponent> selectedChildren) {
        super(designer, "Clear All Weights", null, AndroidDesignerIcons.ClearWeights);
        this.myLayout = layout;
        this.mySelectedChildren = selectedChildren;
    }

    @Override
    protected void performWriteAction() {
        ClearWeightsAction.clearWeights(this.myLayout, this.mySelectedChildren);
    }

    static void clearWeights(RadViewComponent parentNode, List<? extends RadViewComponent> targets) {
        String sizeAttribute = ((RadLinearLayout)parentNode.getLayout()).isHorizontal() ? "layout_width" : "layout_height";
        for (RadViewComponent radViewComponent : targets) {
            XmlAttribute size;
            XmlAttribute weight = radViewComponent.getTag().getAttribute("layout_weight", "http://schemas.android.com/apk/res/android");
            if (weight != null) {
                weight.delete();
            }
            if ((size = radViewComponent.getTag().getAttribute(sizeAttribute, "http://schemas.android.com/apk/res/android")) == null || !size.getValue().startsWith("0")) continue;
            size.setValue("wrap_content");
        }
    }
}

