/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.intellij.android.designer.designSurface.RootView;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintPainter;
import com.intellij.android.designer.model.layout.relative.DependencyGraph;
import com.intellij.android.designer.model.layout.relative.GuidelineHandler;
import com.intellij.android.designer.model.layout.relative.Match;
import com.intellij.android.designer.model.layout.relative.MoveHandler;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.model.RadComponent;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public final class GuidelinePainter
extends JComponent {
    private static final AlphaComposite ALPHA_COMPOSITE = AlphaComposite.getInstance(10, 0.5f);
    private final GuidelineHandler myState;

    public GuidelinePainter(GuidelineHandler state) {
        this.myState = state;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        DesignerGraphics g = new DesignerGraphics(graphics, this);
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(DesignerGraphics g) {
        g.useStyle(DrawingStyle.DRAGGED);
        for (RadViewComponent dragged : this.myState.myDraggedNodes) {
            Rectangle bounds = dragged.getBounds(g.getTarget());
            if (bounds.isEmpty()) continue;
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        Set<RadViewComponent> horizontalDeps = this.myState.myHorizontalDeps;
        Set<RadViewComponent> verticalDeps = this.myState.myVerticalDeps;
        HashSet<RadViewComponent> deps = new HashSet<RadViewComponent>(horizontalDeps.size() + verticalDeps.size());
        deps.addAll(horizontalDeps);
        deps.addAll(verticalDeps);
        if (deps.size() > 0) {
            g.useStyle(DrawingStyle.DEPENDENCY);
            for (RadViewComponent n : deps) {
                if (this.myState.myDraggedNodes.contains((Object)n)) continue;
                Rectangle bounds = n.getBounds(g.getTarget());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        if (!this.myState.layout.getPadding().isEmpty() || !this.myState.layout.getMargins().isEmpty()) {
            g.useStyle(DrawingStyle.PADDING_BOUNDS);
            FeedbackLayer target = this.myState.myContext.getArea().getFeedbackLayer();
            Rectangle bounds = this.myState.layout.getPaddedBounds((Component)target);
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (this.myState.myBounds != null) {
            Rectangle bounds = this.myState.myBounds;
            if (this.myState instanceof MoveHandler) {
                List myComponents = this.myState.getContext().getComponents();
                if (myComponents.size() == 1) {
                    RadComponent component = (RadComponent)myComponents.get(0);
                    Rectangle targetBounds = component.getBounds((Component)g.getTarget());
                    RootView nativeComponent = (RootView)((RadViewComponent)component.getRoot()).getNativeComponent();
                    if (nativeComponent != null) {
                        BufferedImage image = nativeComponent.getImage();
                        Rectangle sourceBounds = component.getBounds();
                        Graphics2D g2d = (Graphics2D)g.getGraphics();
                        Composite prevComposite = g2d.getComposite();
                        try {
                            if (image != null) {
                                g2d.setComposite(ALPHA_COMPOSITE);
                                g2d.drawImage(image, bounds.x, bounds.y, bounds.x + targetBounds.width, bounds.y + targetBounds.height, sourceBounds.x, sourceBounds.y, sourceBounds.x + sourceBounds.width, sourceBounds.y + sourceBounds.height, null);
                            }
                        }
                        finally {
                            g2d.setComposite(prevComposite);
                        }
                    }
                }
                g.useStyle(DrawingStyle.DROP_PREVIEW);
            } else if (this.myState.haveSuggestions()) {
                g.useStyle(DrawingStyle.RESIZE_PREVIEW);
            } else {
                g.useStyle(DrawingStyle.RESIZE_FAIL);
            }
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        GuidelinePainter.showMatch(g, this.myState.getCurrentLeftMatch(), this.myState);
        GuidelinePainter.showMatch(g, this.myState.getCurrentRightMatch(), this.myState);
        GuidelinePainter.showMatch(g, this.myState.getCurrentTopMatch(), this.myState);
        GuidelinePainter.showMatch(g, this.myState.getCurrentBottomMatch(), this.myState);
        if (this.myState.myHorizontalCycle != null) {
            this.paintCycle(g, this.myState.myHorizontalCycle);
        }
        if (this.myState.myVerticalCycle != null) {
            this.paintCycle(g, this.myState.myVerticalCycle);
        }
    }

    private static void showMatch(DesignerGraphics g, Match m, GuidelineHandler state) {
        if (m == null) {
            return;
        }
        ConstraintPainter.paintConstraint(g, state, m);
    }

    private static Point center(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    void paintCycle(DesignerGraphics g, List<DependencyGraph.Constraint> cycle) {
        assert (cycle.size() > 0);
        RadViewComponent from = cycle.get((int)0).from.node;
        assert (from != null);
        Rectangle fromBounds = from.getBounds(g.getTarget());
        if (this.myState.myDraggedNodes.contains((Object)from)) {
            fromBounds = this.myState.myBounds;
        }
        Point fromCenter = GuidelinePainter.center(fromBounds);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(fromCenter);
        for (DependencyGraph.Constraint constraint : cycle) {
            assert (constraint.from.node == from);
            RadViewComponent to = constraint.to.node;
            assert (to != null);
            Point toCenter = GuidelinePainter.center(to.getBounds(g.getTarget()));
            points.add(toCenter);
            boolean isDragged = this.myState.myDraggedNodes.contains((Object)to);
            if (isDragged) {
                toCenter = GuidelinePainter.center(this.myState.myBounds);
                points.add(toCenter);
            }
            from = to;
            fromCenter = toCenter;
        }
        points.add(fromCenter);
        points.add((Point)points.get(0));
        g.useStyle(DrawingStyle.CYCLE);
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            Point a = (Point)points.get(i - 1);
            Point b = (Point)points.get(i);
            g.drawLine(a.x, a.y, b.x, b.y);
        }
    }
}

