/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.idea.designer.Segment;
import com.intellij.android.designer.designSurface.feedbacks.TextFeedback;
import com.intellij.android.designer.model.layout.TextDirection;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;

class Match {
    public final Segment with;
    public final Segment edge;
    public final int delta;
    public final ConstraintType type;
    public boolean cycle;
    private static final SimpleTextAttributes SNAP_ATTRIBUTES = new SimpleTextAttributes(1, new Color(60, 139, 186));

    public Match(Segment edge, Segment with, ConstraintType type, int delta) {
        this.edge = edge;
        this.with = with;
        this.type = type;
        this.delta = delta;
    }

    public String getConstraint(boolean generateId) {
        if (this.type.targetParent) {
            return this.type.name + '=' + "true";
        }
        String id = this.edge.id;
        if (id == null || id.length() == -1) {
            if (!generateId) {
                id = "<generated>";
            } else if (this.edge.node != null) {
                id = this.edge.node.ensureId();
            }
        }
        return this.type.name + '=' + id;
    }

    public String toString() {
        return "Match [type=" + (Object)((Object)this.type) + ", delta=" + this.delta + ", edge=" + this.edge + "]";
    }

    public void describe(TextFeedback feedback, int margin, String marginAttribute) {
        feedback.clear();
        String constraint = this.getConstraint(false);
        String description = constraint.replace("@+id/", "").replace("@id/", "");
        if (description.startsWith("layout_")) {
            description = description.substring("layout_".length());
        }
        if (description.endsWith("=true")) {
            description = description.substring(0, description.length() - "=true".length());
        }
        feedback.append(description, SNAP_ATTRIBUTES);
        if (margin > 0) {
            feedback.append(String.format(", margin=%1$d dp", margin));
        }
    }

    public String getRtlConstraint(TextDirection textDirection, boolean generateId) {
        switch (this.type) {
            case ALIGN_LEFT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignLeft", textDirection.getAttrLeft());
            }
            case LAYOUT_LEFT_OF: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_toLeftOf", textDirection.getAttrLeftOf());
            }
            case ALIGN_RIGHT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignRight", textDirection.getAttrRight());
            }
            case LAYOUT_RIGHT_OF: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_toRightOf", textDirection.getAttrRightOf());
            }
            case ALIGN_PARENT_LEFT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignParentLeft", textDirection.getAttrAlignParentLeft());
            }
            case ALIGN_PARENT_RIGHT: {
                return Match.replaceAttribute(this.getConstraint(generateId), "layout_alignParentRight", textDirection.getAttrAlignParentRight());
            }
        }
        return null;
    }

    private static String replaceAttribute(String s, String oldName, String newName) {
        assert (s.startsWith(oldName)) : s;
        return newName + s.substring(oldName.length());
    }
}

