/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.PropertyWithNamespace;
import com.intellij.android.designer.propertyTable.TextEditorWithAutoCommit;
import com.intellij.android.designer.propertyTable.editors.EventHandlerEditor;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.android.designer.propertyTable.editors.StringsComboEditor;
import com.intellij.android.designer.propertyTable.renderers.EventHandlerRenderer;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class AttributeProperty
extends PropertyWithNamespace
implements IXmlAttributeLocator {
    protected final AttributeDefinition myDefinition;
    private final PropertyRenderer myRenderer;
    private final PropertyEditor myEditor;
    private String myTooltip;
    private String myJavadocText;

    public AttributeProperty(String name, AttributeDefinition definition) {
        this(null, name, definition);
    }

    public AttributeProperty(Property parent, String name, AttributeDefinition definition) {
        super(parent, name);
        this.myDefinition = definition;
        Set<AttributeFormat> formats = definition.getFormats();
        if ("onClick".equals(this.getName())) {
            this.myRenderer = new EventHandlerRenderer(formats);
            this.myEditor = new EventHandlerEditor();
            return;
        }
        if (formats.size() == 1) {
            if (formats.contains((Object)AttributeFormat.Float)) {
                this.myRenderer = new LabelPropertyRenderer(null);
                this.myEditor = new TextEditorWithAutoCommit();
                return;
            }
            if (formats.contains((Object)AttributeFormat.Enum)) {
                this.myRenderer = new LabelPropertyRenderer(null);
                this.myEditor = new StringsComboEditor(definition.getValues());
                return;
            }
        }
        this.myRenderer = this.createResourceRenderer(definition, formats);
        this.myEditor = this.createResourceEditor(definition, formats);
    }

    @Override
    protected String getAttributeName() {
        return this.myDefinition.getName();
    }

    protected PropertyRenderer createResourceRenderer(AttributeDefinition definition, Set<AttributeFormat> formats) {
        return new ResourceRenderer(formats);
    }

    protected PropertyEditor createResourceEditor(AttributeDefinition definition, Set<AttributeFormat> formats) {
        String type = AndroidDomUtil.SPECIAL_RESOURCE_TYPES.get(definition.getName());
        if (type == null) {
            return new ResourceEditor(formats, definition.getValues());
        }
        return new ResourceEditor(new ResourceType[]{ResourceType.getEnum((String)type)}, formats, definition.getValues());
    }

    public Property<RadViewComponent> createForNewPresentation(Property parent, String name) {
        return new AttributeProperty(parent, name, this.myDefinition);
    }

    public String getTooltip() {
        if (this.myTooltip == null) {
            this.myTooltip = this.myDefinition.getFormats().toString();
            this.myTooltip = this.myTooltip.substring(1, this.myTooltip.length() - 1);
        }
        return this.myTooltip;
    }

    public Object getValue(RadViewComponent component) throws Exception {
        String attributeValue;
        XmlAttribute attribute = this.getAttribute(component);
        if (attribute != null && (attributeValue = attribute.getValue()) != null) {
            return XmlUtils.fromXmlAttributeValue((String)attributeValue);
        }
        return "";
    }

    public void setValue(final RadViewComponent component, final Object value) throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (StringUtil.isEmpty((String)((String)value))) {
                    XmlAttribute attribute = AttributeProperty.this.getAttribute(component);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    String namespace = AttributeProperty.this.getNamespace(component, true);
                    String escapedValue = XmlUtils.toXmlAttributeValue((String)((String)value));
                    component.getTag().setAttribute(AttributeProperty.this.myDefinition.getName(), namespace, escapedValue);
                }
            }
        });
    }

    public boolean isDefaultValue(RadViewComponent component) throws Exception {
        return this.getAttribute(component) == null;
    }

    public void setDefaultValue(RadViewComponent component) throws Exception {
        if (this.getAttribute(component) != null) {
            this.setValue(component, null);
        }
    }

    private XmlAttribute getAttribute(RadViewComponent component) {
        return component.getTag().getAttribute(this.myDefinition.getName(), this.getNamespace(component, false));
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return this.getAttribute(component) == attribute;
    }

    public PropertyRenderer getRenderer() {
        return this.myRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        String javadocText;
        if (this.myJavadocText == null && (javadocText = this.myDefinition.getDocValue(null)) != null) {
            this.myJavadocText = JavadocParser.build(this.getName(), javadocText);
        }
        return this.myJavadocText;
    }
}

