/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.AttributeProperty;
import com.intellij.designer.model.Property;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;

public class AttributePropertyWithDefault
extends AttributeProperty {
    private final String myDefaultValue;

    public AttributePropertyWithDefault(String name, AttributeDefinition definition, String defaultValue) {
        this(null, name, definition, defaultValue);
    }

    public AttributePropertyWithDefault(Property parent, String name, AttributeDefinition definition, String defaultValue) {
        super(parent, name, definition);
        this.myDefaultValue = defaultValue;
    }

    @Override
    public Property<RadViewComponent> createForNewPresentation(Property parent, String name) {
        return new AttributePropertyWithDefault(parent, name, this.myDefinition, this.myDefaultValue);
    }

    @Override
    public boolean isDefaultValue(RadViewComponent component) throws Exception {
        return this.myDefaultValue.equals(this.getValue(component));
    }

    @Override
    public void setDefaultValue(RadViewComponent component) throws Exception {
        super.setValue(component, (Object)this.myDefaultValue);
    }

    @Override
    public void setValue(RadViewComponent component, Object value) throws Exception {
        if (StringUtil.isEmpty((String)((String)value))) {
            value = this.myDefaultValue;
        }
        super.setValue(component, value);
    }
}

