/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.propertyTable.CompoundProperty;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.EnumSet;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class CompoundDimensionProperty
extends CompoundProperty {
    private ResourceRenderer myRenderer = new ResourceRenderer(EnumSet.of(AttributeFormat.Dimension)){

        @Override
        protected void formatValue(RadComponent component, String value) {
            this.myColoredComponent.append("[");
            if (!StringUtil.isEmpty((String)value)) {
                int index = 0;
                for (String childValue : StringUtil.split((String)value, (String)",")) {
                    if (index++ > 0) {
                        this.myColoredComponent.append(", ");
                    }
                    if ((childValue = childValue.trim()).length() <= 0) continue;
                    if (childValue.equals("?")) {
                        this.myColoredComponent.append("?", SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
                        continue;
                    }
                    super.formatValue(component, childValue);
                }
            }
            this.myColoredComponent.append("]");
        }
    };

    public CompoundDimensionProperty(String name) {
        super(name);
    }

    @Override
    protected CompoundProperty createForNewPresentation(String name) {
        return new CompoundDimensionProperty(name);
    }

    @Override
    public PropertyRenderer getRenderer() {
        return this.myRenderer;
    }
}

