/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadCustomViewComponent;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.List;

public class CustomViewProperty
extends Property<RadCustomViewComponent>
implements IXmlAttributeLocator {
    private static final String JAVA_DOC = JavadocParser.build("view:class", "The fully qualified name of the class.");
    private final PropertyRenderer myRenderer = new LabelPropertyRenderer(null);
    private final PropertyEditor myEditor = new ResourceEditor(null, Collections.emptySet(), null){

        @Override
        protected void showDialog() {
            String view = RadCustomViewComponent.chooseView(this.myRootComponent);
            if (view != null) {
                this.setValue(view);
            }
        }
    };

    public CustomViewProperty() {
        super(null, "view:class");
        this.setImportant(true);
    }

    public Property<RadCustomViewComponent> createForNewPresentation(Property parent, String name) {
        return null;
    }

    public Object getValue(RadCustomViewComponent component) throws Exception {
        String viewClass = component.getViewClass();
        return viewClass == null ? "" : viewClass;
    }

    public void setValue(final RadCustomViewComponent component, final Object value) throws Exception {
        if (StringUtil.isEmpty((String)((String)value))) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag tag = component.getTag();
                if ("view".equals(tag.getName())) {
                    tag.setAttribute("class", (String)value);
                } else {
                    tag.setName((String)value);
                }
            }
        });
        component.extractClientProperty("view.model");
        component.setProperties(Collections.<Property>emptyList());
        PropertyParser parser = RadModelBuilder.getPropertyParser((RadComponent)component);
        if (parser != null) {
            parser.load(component);
        }
    }

    public boolean isDefaultValue(RadCustomViewComponent component) throws Exception {
        return false;
    }

    public void setDefaultValue(RadCustomViewComponent component) throws Exception {
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }

    public boolean needRefreshPropertyList() {
        return true;
    }

    public PropertyRenderer getRenderer() {
        return this.myRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        return JAVA_DOC;
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return component.getTag().getAttribute("class") == attribute;
    }
}

