/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.android.designer.model.IdManager;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.AttributeProperty;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class IdProperty
extends AttributeProperty {
    private static final int REFACTOR_ASK = 0;
    private static final int REFACTOR_NO = 1;
    private static final int REFACTOR_YES = 2;
    private static int ourRefactoringChoice = 0;
    public static final Property INSTANCE = new IdProperty();
    private final PropertyRenderer myRenderer = new IdPropertyRenderer();
    private final IdPropertyEditor myEditor = new IdPropertyEditor();

    private IdProperty() {
        this("id", new AttributeDefinition("id", null, Collections.singletonList(AttributeFormat.Reference)));
        this.setImportant(true);
    }

    public IdProperty(String name, AttributeDefinition definition) {
        super(name, definition);
    }

    public IdProperty(Property parent, String name, AttributeDefinition definition) {
        super(parent, name, definition);
    }

    @Override
    public Property<RadViewComponent> createForNewPresentation(Property parent, String name) {
        return new IdProperty(parent, name, this.myDefinition);
    }

    @Override
    public void setValue(RadViewComponent component, Object value) throws Exception {
        XmlAttributeValue valueElement;
        Module module;
        XmlTag tag;
        XmlAttribute attribute;
        String newId = value != null ? value.toString() : "";
        String oldId = component.getId();
        if (ourRefactoringChoice != 1 && oldId != null && !oldId.isEmpty() && !newId.isEmpty() && !oldId.equals(newId) && component.getTag().isValid() && (attribute = (tag = component.getTag()).getAttribute("id", "http://schemas.android.com/apk/res/android")) != null && (module = RadModelBuilder.getModule((RadComponent)component)) != null && (valueElement = attribute.getValueElement()) != null && valueElement.isValid()) {
            Project project = module.getProject();
            RenameProcessor processor = new RenameProcessor(project, (PsiElement)valueElement, newId, false, false);
            processor.setPreviewUsages(false);
            UsageInfo[] usages = processor.findUsages();
            if (usages.length > 0) {
                int choice = ourRefactoringChoice;
                if (choice == 0) {
                    DialogBuilder builder = new DialogBuilder(project);
                    builder.setTitle("Update Usages?");
                    JPanel panel = new JPanel(new BorderLayout());
                    JLabel label = new JLabel("<html>Update usages as well?<br>This will update all XML references and Java R field references.<br><br></html>");
                    panel.add((Component)label, "Center");
                    JBCheckBox checkBox = new JBCheckBox("Don't ask again during this session");
                    panel.add((Component)checkBox, "South");
                    builder.setCenterPanel((JComponent)panel);
                    builder.setDimensionServiceKey("idPropertyDimension");
                    builder.removeAllActions();
                    DialogBuilder.CustomizableAction yesAction = builder.addOkAction();
                    yesAction.setText(Messages.YES_BUTTON);
                    builder.addActionDescriptor(new DialogBuilder.ActionDescriptor(){

                        public Action getAction(final DialogWrapper dialogWrapper) {
                            return new AbstractAction(Messages.NO_BUTTON){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    dialogWrapper.close(2);
                                }
                            };
                        }
                    });
                    builder.addCancelAction();
                    int exitCode = builder.show();
                    choice = exitCode == 0 ? 2 : (exitCode == 2 ? 1 : ourRefactoringChoice);
                    int n = ourRefactoringChoice = checkBox.isSelected() ? choice : 0;
                    if (exitCode == 1) {
                        return;
                    }
                }
                if (choice == 2) {
                    processor.run();
                }
            }
        }
        super.setValue(component, value);
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return false;
    }

    @Override
    public PropertyRenderer getRenderer() {
        return this.myRenderer;
    }

    @Override
    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    private static class IdPropertyEditor
    extends PropertyEditor {
        private final JTextField myEditor;

        private IdPropertyEditor() {
            JTextField textField = this.myEditor = new JTextField();
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdPropertyEditor.this.fireValueCommitted(false, true);
                }
            });
            ResourceEditor.selectTextOnFocusGain(textField);
        }

        public JComponent getComponent(PropertiesContainer container, PropertyContext context, Object value, InplaceContext inplaceContext) {
            this.myEditor.setText(value != null ? IdManager.getIdName(value.toString()) : "");
            this.preferredSizeChanged();
            return this.myEditor;
        }

        public Object getValue() throws Exception {
            ResourceNameValidator validator;
            String errorText;
            String name;
            String text = this.myEditor.getText().trim();
            if (text.isEmpty()) {
                return text;
            }
            if (!text.startsWith("@")) {
                text = "@+id/" + text;
            }
            if ((name = LintUtils.stripIdPrefix((String)text)).length() > 0 && (errorText = (validator = ResourceNameValidator.create(false, (Set<String>)null, ResourceType.ID)).getErrorText(name)) != null) {
                throw new IllegalArgumentException(errorText);
            }
            return text;
        }

        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.myEditor);
        }
    }

    private static class IdPropertyRenderer
    extends LabelPropertyRenderer {
        public IdPropertyRenderer() {
            super(null);
        }

        public JComponent getComponent(PropertiesContainer container, PropertyContext context, Object value, boolean selected, boolean hasFocus) {
            String s = value != null ? value.toString() : "";
            value = IdManager.getIdName(s);
            return super.getComponent(container, context, value, selected, hasFocus);
        }
    }
}

