/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.android.resources.ResourceType;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.editors.ResourceEditor;
import com.intellij.android.designer.propertyTable.renderers.ResourceRenderer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.Collections;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class StyleProperty
extends Property<RadViewComponent>
implements IXmlAttributeLocator {
    public static final ResourceType[] STYLE_TYPES = new ResourceType[]{ResourceType.STYLE};
    private final PropertyRenderer myRenderer = new ResourceRenderer(Collections.<AttributeFormat>emptySet());
    private final PropertyEditor myEditor = new ResourceEditor(STYLE_TYPES, Collections.<AttributeFormat>emptySet(), null);
    private final String myJavadocText = JavadocParser.build("style", "A reference to a custom style");

    public StyleProperty() {
        super(null, "style");
        this.setImportant(true);
    }

    public Property<RadViewComponent> createForNewPresentation(Property parent, String name) {
        return null;
    }

    public PropertyRenderer getRenderer() {
        return this.myRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public Object getValue(RadViewComponent component) throws Exception {
        String value = null;
        XmlAttribute attribute = StyleProperty.getAttribute(component);
        if (attribute != null) {
            value = attribute.getValue();
        }
        return value == null ? "" : value;
    }

    public void setValue(final RadViewComponent component, final Object value) throws Exception {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (StringUtil.isEmpty((String)((String)value))) {
                    XmlAttribute attribute = StyleProperty.getAttribute(component);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    component.getTag().setAttribute("style", (String)value);
                }
            }
        });
    }

    public boolean isDefaultValue(RadViewComponent component) throws Exception {
        return StyleProperty.getAttribute(component) == null;
    }

    public void setDefaultValue(RadViewComponent component) throws Exception {
        if (StyleProperty.getAttribute(component) != null) {
            this.setValue(component, null);
        }
    }

    private static XmlAttribute getAttribute(RadViewComponent component) {
        return component.getTag().getAttribute("style");
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        return StyleProperty.getAttribute(component) == attribute;
    }

    public String getJavadocText() {
        return this.myJavadocText;
    }
}

