/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable.editors;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.renderers.ComponentRenderer;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.editors.ComboEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public abstract class ComponentEditor
extends ComboEditor {
    private final ComponentRenderer myRenderer;

    public ComponentEditor(ComponentRenderer renderer) {
        this.myRenderer = renderer;
        this.myCombo.setRenderer((ListCellRenderer)((Object)renderer));
        this.myCombo.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComponentEditor.this.myCombo.getSelectedItem() == "<unset>") {
                    ComponentEditor.this.myCombo.setSelectedItem(null);
                }
            }
        });
    }

    public Object getValue() throws Exception {
        if (this.myCombo.getSelectedItem() instanceof RadViewComponent) {
            RadViewComponent component = (RadViewComponent)((Object)this.myCombo.getSelectedItem());
            return component.getId();
        }
        return null;
    }

    public JComponent getComponent(PropertiesContainer container, PropertyContext context, Object value, InplaceContext inplaceContext) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("<unset>");
        this.myCombo.setModel(model);
        if (container instanceof RadComponent) {
            for (RadComponent childComponent : this.getComponents((RadComponent)container)) {
                model.addElement((String)childComponent);
            }
            this.myCombo.setSelectedItem((Object)this.myRenderer.getComponentById((RadComponent)container, (String)value));
        }
        this.myCombo.setBorder(inplaceContext == null ? null : this.myComboBorder);
        return this.myCombo;
    }

    protected abstract List<RadComponent> getComponents(RadComponent var1);
}

