/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;

public class AndroidGotoRelatedProvider
extends GotoRelatedProvider {
    public static boolean ourAddDeclarationToManifest = false;
    private static final String[] CONTEXT_CLASSES = new String[]{"android.app.Activity", "android.app.Fragment", "android.support.v4.app.Fragment", "android.widget.Adapter"};

    public List<? extends GotoRelatedItem> getItems(PsiElement element) {
        Computable<List<GotoRelatedItem>> items = AndroidGotoRelatedProvider.getLazyItemsComputable(element);
        return items != null ? (List)items.compute() : Collections.emptyList();
    }

    private static Computable<List<GotoRelatedItem>> getLazyItemsComputable(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof XmlFile) && !(file instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Project project = element.getProject();
        if (!FileIndexFacade.getInstance((Project)project).isInContent(vFile)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            PsiClass[] rootClasses;
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null && (rootClasses = ((PsiJavaFile)file).getClasses()).length == 1) {
                aClass = rootClasses[0];
            }
            if (aClass != null) {
                return AndroidGotoRelatedProvider.getLazyItemsForClass(aClass, facet, ourAddDeclarationToManifest);
            }
        } else {
            return AndroidGotoRelatedProvider.getLazyItemsForXmlFile((XmlFile)file, facet);
        }
        return null;
    }

    public static Computable<List<GotoRelatedItem>> getLazyItemsForXmlFile(XmlFile file, AndroidFacet facet) {
        String resourceType = facet.getLocalResourceManager().getFileResourceType((PsiFile)file);
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            return AndroidGotoRelatedProvider.collectRelatedJavaFiles(file, facet);
        }
        return null;
    }

    static Computable<List<GotoRelatedItem>> getLazyItemsForClass(PsiClass aClass, AndroidFacet facet, boolean addDeclarationInManifest) {
        List<GotoRelatedItem> items;
        GotoRelatedItem item = AndroidGotoRelatedProvider.findDeclarationInManifest(aClass);
        boolean isContextClass = AndroidGotoRelatedProvider.isInheritorOfContextClass(aClass, facet.getModule());
        if (!isContextClass && item == null) {
            return null;
        }
        if (isContextClass) {
            items = new ArrayList<GotoRelatedItem>(AndroidGotoRelatedProvider.collectRelatedLayoutFiles(facet, aClass));
            if (addDeclarationInManifest && item != null) {
                items.add(item);
            }
            if (items.isEmpty()) {
                return null;
            }
        } else {
            items = Collections.singletonList(item);
        }
        return new Computable<List<GotoRelatedItem>>(){

            public List<GotoRelatedItem> compute() {
                return items;
            }
        };
    }

    private static GotoRelatedItem findDeclarationInManifest(PsiClass psiClass) {
        AndroidAttributeValue<PsiClass> domAttrValue = AndroidDomUtil.findComponentDeclarationInManifest(psiClass);
        if (domAttrValue == null) {
            return null;
        }
        XmlAttributeValue attrValue = domAttrValue.getXmlAttributeValue();
        return attrValue != null ? new MyGotoManifestItem(attrValue) : null;
    }

    private static boolean isInheritorOfContextClass(PsiClass psiClass, Module module) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (String contextClassName : CONTEXT_CLASSES) {
            PsiClass contextClass = facade.findClass(contextClassName, module.getModuleWithDependenciesAndLibrariesScope(false));
            if (contextClass == null || !psiClass.isInheritor(contextClass, true)) continue;
            return true;
        }
        return false;
    }

    private static Computable<List<GotoRelatedItem>> collectRelatedJavaFiles(final XmlFile file, AndroidFacet facet) {
        String resourceName;
        String resType = ResourceType.LAYOUT.getName();
        PsiField[] fields = AndroidResourceUtil.findResourceFields(facet, resType, resourceName = AndroidCommonUtils.getResourceName((String)resType, (String)file.getName()), true);
        if (fields.length == 0 || fields.length > 1) {
            return null;
        }
        final PsiField field = fields[0];
        final Module module = facet.getModule();
        final GlobalSearchScope scope = module.getModuleScope(false);
        return new Computable<List<GotoRelatedItem>>(){

            public List<GotoRelatedItem> compute() {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
                final ArrayList<PsiClass> psiContextClasses = new ArrayList<PsiClass>();
                PsiClass declared = AndroidPsiUtils.getContextClass(module, file);
                if (declared != null) {
                    return Collections.singletonList(new GotoRelatedItem((PsiElement)declared, "JAVA"));
                }
                for (String contextClassName : CONTEXT_CLASSES) {
                    PsiClass contextClass = facade.findClass(contextClassName, module.getModuleWithDependenciesAndLibrariesScope(false));
                    if (contextClass == null) continue;
                    psiContextClasses.add(contextClass);
                }
                if (psiContextClasses.isEmpty()) {
                    return Collections.emptyList();
                }
                final ArrayList<GotoRelatedItem> result = new ArrayList<GotoRelatedItem>();
                ReferencesSearch.search((PsiElement)field, (SearchScope)scope).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference reference) {
                        PsiClass relatedClass;
                        PsiElement element = reference.getElement();
                        if (!(element instanceof PsiReferenceExpression)) {
                            return true;
                        }
                        if (!((element = element.getParent()) instanceof PsiExpressionList)) {
                            return true;
                        }
                        if (!((element = element.getParent()) instanceof PsiMethodCallExpression)) {
                            return true;
                        }
                        String methodName = ((PsiMethodCallExpression)element).getMethodExpression().getReferenceName();
                        if (("setContentView".equals(methodName) || "inflate".equals(methodName)) && (relatedClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null && AndroidGotoRelatedProvider.isInheritorOfOne(relatedClass, psiContextClasses)) {
                            result.add(new GotoRelatedItem((PsiElement)relatedClass, "JAVA"));
                        }
                        return true;
                    }
                });
                return result;
            }
        };
    }

    private static boolean isInheritorOfOne(PsiClass psiClass, Collection<PsiClass> possibleBaseClasses) {
        for (PsiClass baseClass : possibleBaseClasses) {
            if (!psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return false;
    }

    private static List<GotoRelatedItem> collectRelatedLayoutFiles(final AndroidFacet facet, PsiClass context) {
        HashSet files = new HashSet();
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)files){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                String resClassName = ResourceType.LAYOUT.getName();
                AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, expression, resClassName, true);
                if (info == null || info.isFromManifest()) {
                    return;
                }
                String resFieldName = info.getFieldName();
                List<PsiElement> resources = facet.getLocalResourceManager().findResourcesByFieldName(resClassName, resFieldName);
                for (PsiElement resource : resources) {
                    if (!(resource instanceof PsiFile)) continue;
                    this.val$files.add((PsiFile)resource);
                }
            }
        });
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GotoRelatedItem> result = new ArrayList<GotoRelatedItem>(files.size());
        for (PsiFile file : files) {
            result.add(new MyGotoRelatedLayoutItem(file));
        }
        return result;
    }

    private static class MyGotoManifestItem
    extends GotoRelatedItem {
        public MyGotoManifestItem(XmlAttributeValue attributeValue) {
            super((PsiElement)attributeValue);
        }

        public String getCustomName() {
            return "AndroidManifest.xml";
        }

        public String getCustomContainerName() {
            return "";
        }

        public Icon getCustomIcon() {
            return XmlFileType.INSTANCE.getIcon();
        }
    }

    private static class MyGotoRelatedLayoutItem
    extends GotoRelatedItem {
        private final PsiFile myFile;

        public MyGotoRelatedLayoutItem(PsiFile file) {
            super((PsiElement)file, "Layout Files");
            this.myFile = file;
        }

        public String getCustomContainerName() {
            PsiDirectory directory = this.myFile.getContainingDirectory();
            return directory != null ? "(" + directory.getName() + ")" : null;
        }
    }
}

