/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.Consumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;

public class AndroidJavaCompletionContributor
extends CompletionContributor {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"javax.swing", "javafx"};

    public void fillCompletionVariants(CompletionParameters parameters, final CompletionResultSet resultSet) {
        PsiReferenceExpression ref3;
        PsiReferenceExpression ref2;
        PsiReferenceExpression ref;
        super.fillCompletionVariants(parameters, resultSet);
        PsiElement position = parameters.getPosition();
        AndroidFacet facet = AndroidFacet.getInstance(position);
        if (facet == null) {
            return;
        }
        if (AndroidMavenUtil.isMavenizedModule(facet.getModule())) {
            resultSet.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

                public void consume(CompletionResult result) {
                    String qName;
                    Object obj = result.getLookupElement().getObject();
                    if (obj instanceof PsiClass && (qName = ((PsiClass)obj).getQualifiedName()) != null && !AndroidJavaCompletionContributor.isAllowedInAndroid(qName)) {
                        return;
                    }
                    resultSet.passResult(result);
                }
            });
        }
        if (position.getParent() instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)position.getParent()).getQualifierExpression() != null && ref.getQualifierExpression() instanceof PsiReferenceExpression && (ref2 = (PsiReferenceExpression)ref.getQualifierExpression()).getQualifierExpression() instanceof PsiReferenceExpression && (ref3 = (PsiReferenceExpression)ref2.getQualifierExpression()).getQualifierExpression() == null && "R".equals(ref3.getReferenceName())) {
            this.filterPrivateResources(parameters, resultSet, facet);
        }
    }

    public void filterPrivateResources(CompletionParameters parameters, final CompletionResultSet resultSet, AndroidFacet facet) {
        final ResourceVisibilityLookup lookup = AppResourceRepository.getAppResources(facet, true).getResourceVisibility(facet);
        if (lookup.isEmpty()) {
            return;
        }
        resultSet.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult result) {
                ResourceType type;
                PsiClass rClass;
                PsiField field;
                PsiClass containingClass;
                Object obj = result.getLookupElement().getObject();
                if (obj instanceof PsiField && (containingClass = (field = (PsiField)obj).getContainingClass()) != null && (rClass = containingClass.getContainingClass()) != null && rClass.getName().equals("R") && (type = ResourceType.getEnum((String)containingClass.getName())) != null && lookup.isPrivate(type, field.getName())) {
                    return;
                }
                resultSet.passResult(result);
            }
        });
    }

    private static boolean isAllowedInAndroid(String qName) {
        for (String aPackage : EXCLUDED_PACKAGES) {
            if (!qName.startsWith(aPackage + ".")) continue;
            return false;
        }
        return true;
    }
}

