/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceType;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NonNls;

public class AndroidValueResourcesIndex
extends FileBasedIndexExtension<ResourceEntry, Set<MyResourceInfo>> {
    public static final ID<ResourceEntry, Set<MyResourceInfo>> INDEX_ID = ID.create((String)"android.value.resources.index");
    @NonNls
    private static final String RESOURCES_ROOT_TAG = "resources";
    @NonNls
    private static final String NAME_ATTRIBUTE_VALUE = "name";
    @NonNls
    private static final String TYPE_ATTRIBUTE_VALUE = "type";
    private final DataIndexer<ResourceEntry, Set<MyResourceInfo>, FileContent> myIndexer = new DataIndexer<ResourceEntry, Set<MyResourceInfo>, FileContent>(){

        public Map<ResourceEntry, Set<MyResourceInfo>> map(FileContent inputData) {
            if (!AndroidValueResourcesIndex.isSimilarFile(inputData)) {
                return Collections.emptyMap();
            }
            PsiFile file = inputData.getPsiFile();
            if (!(file instanceof XmlFile)) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)result){
                final /* synthetic */ Map val$result;
                {
                    this.val$result = map;
                }

                public void visitXmlTag(XmlTag tag) {
                    ResourceType resType;
                    super.visitXmlTag(tag);
                    String resName = tag.getAttributeValue(AndroidValueResourcesIndex.NAME_ATTRIBUTE_VALUE);
                    if (resName == null) {
                        return;
                    }
                    String tagName = tag.getName();
                    String resTypeStr = "item".equals(tagName) ? tag.getAttributeValue(AndroidValueResourcesIndex.TYPE_ATTRIBUTE_VALUE) : AndroidCommonUtils.getResourceTypeByTagName((String)tagName);
                    ResourceType resourceType = resType = resTypeStr != null ? ResourceType.getEnum((String)resTypeStr) : null;
                    if (resType == null) {
                        return;
                    }
                    int offset = tag.getTextRange().getStartOffset();
                    if (resType == ResourceType.ATTR) {
                        XmlTag parentTag = tag.getParentTag();
                        String contextName = parentTag != null ? parentTag.getAttributeValue(AndroidValueResourcesIndex.NAME_ATTRIBUTE_VALUE) : null;
                        AndroidValueResourcesIndex.processResourceEntry(new ResourceEntry(resTypeStr, resName, contextName != null ? contextName : ""), this.val$result, offset);
                    } else {
                        AndroidValueResourcesIndex.processResourceEntry(new ResourceEntry(resTypeStr, resName, ""), this.val$result, offset);
                    }
                }
            });
            return result;
        }
    };
    private final KeyDescriptor<ResourceEntry> myKeyDescriptor = new KeyDescriptor<ResourceEntry>(){

        public void save(DataOutput out, ResourceEntry value) throws IOException {
            out.writeUTF(value.getType());
            out.writeUTF(value.getName());
            out.writeUTF(value.getContext());
        }

        public ResourceEntry read(DataInput in) throws IOException {
            String resType = in.readUTF();
            String resName = in.readUTF();
            String resContext = in.readUTF();
            return new ResourceEntry(resType, resName, resContext);
        }

        public int getHashCode(ResourceEntry value) {
            return value.hashCode();
        }

        public boolean isEqual(ResourceEntry val1, ResourceEntry val2) {
            return val1.equals((Object)val2);
        }
    };
    private final DataExternalizer<Set<MyResourceInfo>> myValueExternalizer = new DataExternalizer<Set<MyResourceInfo>>(){

        public void save(DataOutput out, Set<MyResourceInfo> value) throws IOException {
            out.writeInt(value.size());
            for (MyResourceInfo entry : value) {
                out.writeUTF(entry.getResourceEntry().getType());
                out.writeUTF(entry.getResourceEntry().getName());
                out.writeUTF(entry.getResourceEntry().getContext());
                out.writeInt(entry.getOffset());
            }
        }

        public Set<MyResourceInfo> read(DataInput in) throws IOException {
            int size = in.readInt();
            if (size < 0 || size > 65535) {
                throw new IOException("Corrupt Index: Size " + size);
            }
            if (size == 0) {
                return Collections.emptySet();
            }
            java.util.HashSet result = Sets.newHashSetWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                String type = in.readUTF();
                String name = in.readUTF();
                String context = in.readUTF();
                int offset = in.readInt();
                result.add(new MyResourceInfo(new ResourceEntry(type, name, context), offset));
            }
            return result;
        }
    };

    private static boolean isSimilarFile(FileContent inputData) {
        if (CharArrayUtil.indexOf((CharSequence)inputData.getContentAsText(), (CharSequence)"<resources", (int)0) < 0) {
            return false;
        }
        final boolean[] ourRootTag = new boolean[]{false};
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                ourRootTag[0] = AndroidValueResourcesIndex.RESOURCES_ROOT_TAG.equals(name) && nsPrefix == null;
                2.stop();
            }
        });
        return ourRootTag[0];
    }

    private static void processResourceEntry(ResourceEntry entry, Map<ResourceEntry, Set<MyResourceInfo>> result, int offset) {
        MyResourceInfo info = new MyResourceInfo(entry, offset);
        result.put(entry, Collections.singleton(info));
        AndroidValueResourcesIndex.addEntryToMap(info, AndroidValueResourcesIndex.createTypeMarkerKey(entry.getType()), result);
        AndroidValueResourcesIndex.addEntryToMap(info, AndroidValueResourcesIndex.createTypeNameMarkerKey(entry.getType(), entry.getName()), result);
    }

    private static void addEntryToMap(MyResourceInfo info, ResourceEntry marker, Map<ResourceEntry, Set<MyResourceInfo>> result) {
        HashSet set = result.get(marker);
        if (set == null) {
            set = new HashSet();
            result.put(marker, (Set<MyResourceInfo>)set);
        }
        set.add((MyResourceInfo)info);
    }

    public static ResourceEntry createTypeMarkerKey(String type) {
        return AndroidValueResourcesIndex.createTypeNameMarkerKey(type, "TYPE_MARKER_RESOURCE");
    }

    public static ResourceEntry createTypeNameMarkerKey(String type, String name) {
        return new ResourceEntry(type, AndroidValueResourcesIndex.normalizeDelimiters(name), "TYPE_MARKER_CONTEXT");
    }

    static String normalizeDelimiters(String s) {
        int length = s.length();
        int n = length;
        for (int j = 0; j < n; ++j) {
            char ch = s.charAt(j);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            StringBuilder result = new StringBuilder(length);
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    result.append(c);
                    continue;
                }
                result.append('_');
            }
            return result.toString();
        }
        return s;
    }

    public ID<ResourceEntry, Set<MyResourceInfo>> getName() {
        return INDEX_ID;
    }

    public DataIndexer<ResourceEntry, Set<MyResourceInfo>, FileContent> getIndexer() {
        return this.myIndexer;
    }

    public KeyDescriptor<ResourceEntry> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    public DataExternalizer<Set<MyResourceInfo>> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML}){

            public boolean acceptInput(VirtualFile file) {
                return file.isInLocalFileSystem();
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 5;
    }

    public static class MyResourceInfo {
        private final ResourceEntry myResourceEntry;
        private final int myOffset;

        private MyResourceInfo(ResourceEntry resourceEntry, int offset) {
            this.myResourceEntry = resourceEntry;
            this.myOffset = offset;
        }

        public ResourceEntry getResourceEntry() {
            return this.myResourceEntry;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyResourceInfo info = (MyResourceInfo)o;
            if (this.myOffset != info.myOffset) {
                return false;
            }
            return this.myResourceEntry.equals((Object)info.myResourceEntry);
        }

        public int hashCode() {
            int result = this.myResourceEntry.hashCode();
            result = 31 * result + this.myOffset;
            return result;
        }

        public String toString() {
            return this.getClass().getDeclaringClass().getSimpleName() + '.' + this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '(' + this.myResourceEntry + ',' + this.myOffset + ')';
        }
    }
}

