/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.io.File;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDirectoryDialog;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.util.AndroidBundle;

public class CreateResourceDirectoryAction
extends CreateResourceActionBase {
    private final ResourceFolderType myResourceFolderType;

    public CreateResourceDirectoryAction() {
        this(null);
    }

    public CreateResourceDirectoryAction(ResourceFolderType resourceFolderType) {
        super(AndroidBundle.message("new.resource.dir.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), PlatformIcons.DIRECTORY_CLOSED_ICON);
        this.myResourceFolderType = resourceFolderType;
    }

    public PsiElement[] invokeDialog(final Project project, final PsiDirectory directory) {
        CreateResourceDirectoryDialog dialog = new CreateResourceDirectoryDialog(project, this.myResourceFolderType, directory, AndroidPsiUtils.getModuleSafely((PsiElement)directory)){

            @Override
            protected InputValidator createValidator() {
                return CreateResourceDirectoryAction.this.createValidator(project, directory);
            }
        };
        dialog.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        dialog.show();
        InputValidator validator = dialog.getValidator();
        if (validator == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return ((CreateResourceActionBase.MyInputValidator)validator).getCreatedElements();
    }

    @Override
    public PsiElement[] invokeDialog(Project project, final DataContext dataContext) {
        ResourceFolderType folderType = this.myResourceFolderType;
        if (folderType == null) {
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            folderType = CreateResourceFileAction.getUniqueFolderType(files);
        }
        CreateResourceDirectoryDialog dialog = new CreateResourceDirectoryDialog(project, folderType, CreateResourceDirectoryAction.findResourceDirectory(dataContext), (Module)LangDataKeys.MODULE.getData(dataContext)){

            @Override
            protected InputValidator createValidator() {
                Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
                assert (module != null);
                PsiDirectory resourceDirectory = this.getResourceDirectory(dataContext, true);
                return CreateResourceDirectoryAction.this.createValidator(module.getProject(), resourceDirectory);
            }
        };
        dialog.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        dialog.show();
        InputValidator validator = dialog.getValidator();
        if (validator == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return ((CreateResourceActionBase.MyInputValidator)validator).getCreatedElements();
    }

    private CreateResourceActionBase.MyInputValidator createValidator(Project project, PsiDirectory resDir) {
        return new CreateResourceActionBase.MyInputValidator(project, resDir);
    }

    @Override
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        return new PsiElement[]{directory.createSubdirectory(newName)};
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.dir.command.name", new Object[0]);
    }

    @Override
    protected String getActionName(PsiDirectory directory, String newName) {
        return AndroidBundle.message("new.resource.dir.action.name", directory.getName() + File.separator + newName);
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }
}

